/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.velocity.util;

import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogChute
implements LogChute {
    private static final Logger log = LoggerFactory.getLogger(SLF4JLogChute.class);
    private static final String RUNTIME_LOG_SLF4J_LOGGER = "runtime.log.logsystem.slf4j.logger";
    public static final String DEFAULT_LOGGER = "velocity";

    public void init(RuntimeServices rs) throws Exception {
        String name = (String)rs.getProperty(RUNTIME_LOG_SLF4J_LOGGER);
        if (StringUtils.isBlank((CharSequence)name)) {
            ServletContext context = (ServletContext)rs.getApplicationAttribute((Object)"javax.servlet.ServletContext");
            if (context != null) {
                name = "velocity." + context.getServletContextName();
                name = name.replace("-", ".");
            } else {
                name = DEFAULT_LOGGER;
            }
        }
        this.log(1, "SLF4JLogChute using logger '" + name + '\'');
    }

    public void log(int level, String message) {
        switch (level) {
            case 2: {
                log.warn(message);
                break;
            }
            case 1: {
                log.info(message);
                break;
            }
            case -1: {
                log.trace(message);
                break;
            }
            case 3: {
                log.error(message);
                break;
            }
            default: {
                log.debug(message);
            }
        }
    }

    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                log.warn(message, t);
                break;
            }
            case 1: {
                log.info(message, t);
                break;
            }
            case -1: {
                log.trace(message, t);
                break;
            }
            case 3: {
                log.error(message, t);
                break;
            }
            default: {
                log.debug(message, t);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        switch (level) {
            case 0: {
                return log.isDebugEnabled();
            }
            case 1: {
                return log.isInfoEnabled();
            }
            case -1: {
                return log.isTraceEnabled();
            }
            case 2: {
                return log.isWarnEnabled();
            }
            case 3: {
                return log.isErrorEnabled();
            }
        }
        return true;
    }
}

