/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.quartz.JobExecutionException;
import org.sakaiproject.warehouse.impl.ChildFieldWrapper;
import org.sakaiproject.warehouse.service.ChildWarehouseTask;
import org.sakaiproject.warehouse.service.ItemIndexInParentPropertyAccess;
import org.sakaiproject.warehouse.service.ParentPropertyAccess;
import org.sakaiproject.warehouse.service.PropertyAccess;

public class BaseChildWarehouseTask
implements ChildWarehouseTask {
    private List fields;
    private String insertStmt;
    private String clearStmt;
    private List complexFields;
    private int batchSize = 1000;
    private boolean isPrepared = false;

    public void execute(Object parent, Collection items, Connection connection) throws JobExecutionException {
        Statement ps = null;
        this.isPrepared = false;
        try {
            int current = 0;
            ps = connection.prepareStatement(this.getInsertStmt());
            Iterator i = items.iterator();
            while (i.hasNext()) {
                this.processItem(parent, i.next(), (PreparedStatement)ps, current);
                ps.addBatch();
                if (++current > this.batchSize) {
                    current = 0;
                    ps.executeBatch();
                }
                ps.clearParameters();
            }
            if (current > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new JobExecutionException((Throwable)new Exception("query: " + this.getInsertStmt(), e));
        }
        catch (NullPointerException e) {
            throw new JobExecutionException((Throwable)new Exception("The BaseChildWarehouseTask.execute method parameter items is null. query identifier: " + this.getInsertStmt(), e));
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
        }
    }

    public void prepare(Connection connection) {
        try {
            if (this.isPrepared) {
                return;
            }
            connection.createStatement().execute(this.getClearStmt());
            this.isPrepared = true;
            if (this.getComplexFields() != null) {
                for (ChildFieldWrapper wrapper : this.getComplexFields()) {
                    wrapper.getTask().prepare(connection);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processItem(Object parent, Object item, PreparedStatement ps, int itemIndex) throws JobExecutionException {
        try {
            int index = 1;
            for (Object o : this.getFields()) {
                PropertyAccess pa;
                if (o instanceof PropertyAccess) {
                    pa = (PropertyAccess)o;
                    ps.setObject(index, pa.getPropertyValue(item));
                } else if (o instanceof ParentPropertyAccess) {
                    pa = (ParentPropertyAccess)o;
                    ps.setObject(index, pa.getPropertyValue(parent, item));
                } else if (o instanceof ItemIndexInParentPropertyAccess) {
                    ps.setInt(index, itemIndex);
                }
                ++index;
            }
            if (this.getComplexFields() != null) {
                for (ChildFieldWrapper wrapper : this.getComplexFields()) {
                    Object property = wrapper.getPropertyAccess().getPropertyValue(item);
                    ArrayList<Object> items = null;
                    if (property instanceof Collection) {
                        items = (ArrayList<Object>)property;
                    } else {
                        items = new ArrayList<Object>();
                        if (property != null) {
                            items.add(property);
                        }
                    }
                    wrapper.getTask().execute(item, items, ps.getConnection());
                }
            }
        }
        catch (Exception e) {
            throw new JobExecutionException("error trying to prepare '" + this.insertStmt + "'", (Throwable)e, false);
        }
    }

    public List getFields() {
        return this.fields;
    }

    public void setFields(List fields) {
        this.fields = fields;
    }

    public String getInsertStmt() {
        return this.insertStmt;
    }

    public void setInsertStmt(String insertStmt) {
        this.insertStmt = insertStmt;
    }

    public List getComplexFields() {
        return this.complexFields;
    }

    public void setComplexFields(List complexFields) {
        this.complexFields = complexFields;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getClearStmt() {
        return this.clearStmt;
    }

    public void setClearStmt(String clearStmt) {
        this.clearStmt = clearStmt;
    }
}

