/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;
import org.sakaiproject.warehouse.service.ChildWarehouseTask;
import org.sakaiproject.warehouse.service.DataWarehouseManager;
import org.sakaiproject.warehouse.service.WarehouseTask;
import org.sakaiproject.warehouse.util.db.DbLoader;

public abstract class CallbackWarehouseTask
implements WarehouseTask {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private ChildWarehouseTask task;
    private String tableDdlResource;
    private DataWarehouseManager dataWarehouseManager;
    private ArrayList items = new ArrayList();
    private int batchsize = 1000;

    public void flush() throws Exception {
        this.execute(true);
        this.items.clear();
    }

    public void execute() throws JobExecutionException {
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            connection.setAutoCommit(true);
            this.task.prepare(connection);
        }
        catch (SQLException e) {
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        this.process();
    }

    public void execute(Object object) throws Exception {
        this.items.add(object);
        this.execute(false);
    }

    protected void execute(boolean flush) throws Exception {
        Connection connection = null;
        if (this.items.size() > this.getBatchsize() || flush && this.items.size() > 0) {
            try {
                connection = this.getDataSource().getConnection();
                connection.setAutoCommit(true);
                this.task.execute(null, (Collection)this.items, connection);
            }
            catch (SQLException e) {
                throw new Exception(e);
            }
            catch (JobExecutionException e) {
                this.logger.warn((Object)"Error executing warehousing tasks", (Throwable)e);
                throw new Exception(e);
            }
            finally {
                this.items.clear();
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public void init() {
        this.items.clear();
        Connection connection = null;
        try {
            InputStream tableDdl = this.getTableDdl();
            if (tableDdl != null) {
                connection = this.getDataSource().getConnection();
                connection.setAutoCommit(true);
                DbLoader loader = new DbLoader(connection);
                loader.runLoader(tableDdl);
            }
            this.getDataWarehouseManager().registerTask((WarehouseTask)this);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public InputStream getTableDdl() {
        if (this.getTableDdlResource() != null) {
            return this.getClass().getResourceAsStream(this.getTableDdlResource());
        }
        return null;
    }

    protected abstract void process();

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ChildWarehouseTask getTask() {
        return this.task;
    }

    public void setTask(ChildWarehouseTask task) {
        this.task = task;
    }

    public String getTableDdlResource() {
        return this.tableDdlResource;
    }

    public void setTableDdlResource(String tableDdlResource) {
        this.tableDdlResource = tableDdlResource;
    }

    public DataWarehouseManager getDataWarehouseManager() {
        return this.dataWarehouseManager;
    }

    public void setDataWarehouseManager(DataWarehouseManager dataWarehouseManager) {
        this.dataWarehouseManager = dataWarehouseManager;
    }

    public int getBatchsize() {
        return this.batchsize;
    }

    public void setBatchsize(int batchsize) {
        this.batchsize = batchsize;
    }
}

