/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.sakai.assignment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.assignment.api.Assignment;
import org.sakaiproject.assignment.api.AssignmentService;
import org.sakaiproject.assignment.api.AssignmentSubmission;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.warehouse.sakai.assignment.AssignmentStatus;

public class AssignmentWarehouseService {
    private SiteService siteService;
    private List siteTypes;
    private AssignmentService assService;
    private List roles;
    private final Log logger = LogFactory.getLog(AssignmentWarehouseService.class);

    public List getDWAssignmentStatusAll() {
        ArrayList<AssignmentStatus> assignmentStatus = new ArrayList<AssignmentStatus>();
        List sites_list = this.getAllCourseSites();
        this.logger.info((Object)("Gathering " + sites_list.size() + " course sites to set...."));
        for (Site site : sites_list) {
            Set siteMembers = this.getUsersByRole(site, this.getRoles());
            Iterator assignments = this.assService.getAssignmentsForContext(site.getId());
            while (assignments.hasNext()) {
                Assignment as = (Assignment)assignments.next();
                Iterator members = siteMembers.iterator();
                while (members.hasNext()) {
                    try {
                        User student = UserDirectoryService.getUser((String)((String)members.next()));
                        AssignmentStatus aStats = new AssignmentStatus();
                        AssignmentSubmission asub = this.assService.getSubmission(as.getId(), student);
                        this.setAssignmentStats(aStats, as, asub, site, student);
                        assignmentStatus.add(aStats);
                    }
                    catch (UserNotDefinedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return assignmentStatus;
    }

    private void setAssignmentStats(AssignmentStatus aStats, Assignment as, AssignmentSubmission asub, Site site, User student) {
        if (asub == null) {
            aStats.setAssignment_grade("n/a");
            aStats.setAssignment_status("Not submitted");
        } else {
            aStats.setAssignment_grade(asub.getGrade());
            aStats.setAssignment_status(asub.getStatus());
        }
        aStats.setAssignment_id(as.getId());
        aStats.setStudent_first_name(student.getFirstName());
        aStats.setStudent_last_name(student.getLastName());
        aStats.setUser_id(student.getId());
        aStats.setCourse_title(site.getTitle());
        aStats.setAssignment_title(as.getTitle());
        ResourceProperties srp = student.getProperties();
        ResourceProperties siteRP = site.getProperties();
        String maintainRole = site.getMaintainRole();
        Set instructors = site.getUsersHasRole(maintainRole);
        String instructorsNames = this.getInstructors(instructors);
        aStats.setInstructor(instructorsNames);
    }

    private String getInstructors(Set instructors) {
        String result = "";
        Iterator it = instructors.iterator();
        while (it.hasNext()) {
            try {
                User inst = UserDirectoryService.getUser((String)((String)it.next()));
                if (inst == null || inst.getDisplayId().equalsIgnoreCase("admin")) continue;
                if (result.length() > 0) {
                    result = result.concat(", ");
                }
                result = result.concat(inst.getFirstName() + " " + inst.getLastName());
            }
            catch (UserNotDefinedException unde) {
                unde.printStackTrace();
            }
        }
        return result;
    }

    public List getAllCourseSites() {
        PagingPosition pp = new PagingPosition();
        pp.setPaging(true);
        return this.siteService.getSites(SiteService.SelectionType.ANY, (Object)this.getSiteTypes(), null, null, SiteService.SortType.NONE, null);
    }

    protected Set getUsersByRole(Site site, List roles) {
        HashSet users = new HashSet();
        if (site == null || roles == null || roles.size() < 1) {
            return users;
        }
        int rolesSize = roles.size();
        for (int r = 0; r < rolesSize; ++r) {
            users.addAll(site.getUsersHasRole((String)roles.get(r)));
        }
        return users;
    }

    public AssignmentService getAssService() {
        return this.assService;
    }

    public void setAssService(AssignmentService assService) {
        this.assService = assService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public List getSiteTypes() {
        return this.siteTypes;
    }

    public void setSiteTypes(List siteTypes) {
        this.siteTypes = siteTypes;
    }

    public List getRoles() {
        return this.roles;
    }

    public void setRoles(List roles) {
        this.roles = roles;
    }
}

