/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.util.db;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.warehouse.util.db.TableHandlerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DbLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Connection con;
    private Statement stmt;
    private PreparedStatement pstmt;
    private Document tablesDoc;
    private Document tablesDocGeneric;
    private boolean createTableScript;
    private boolean populateTables;
    private PrintWriter tableScriptOut;
    private boolean dropTables;
    private boolean createTables;
    private String dbName;
    private String dbVersion;
    private String driverName;
    private String driverVersion;
    private boolean alterTables;
    private boolean indexTables;
    private Hashtable tableColumnTypes = new Hashtable();
    private PropertiesHandler propertiesHandler;

    public DbLoader(Connection con) {
        this.con = con;
    }

    public void runLoader(InputStream tables) {
        try {
            XMLReader parser = this.getXMLReader();
            this.readProperties(parser, this.getClass().getResourceAsStream("dbloader.xml"));
            this.propertiesHandler.properties.setDropTables(ServerConfigurationService.getString((String)"sakai.datawarehouse.dbLoader.properties.dropTables", (String)this.propertiesHandler.properties.getDropTables()));
            this.propertiesHandler.properties.setCreateTables(ServerConfigurationService.getString((String)"sakai.datawarehouse.dbLoader.properties.createTables", (String)this.propertiesHandler.properties.getCreateTables()));
            this.propertiesHandler.properties.setAlterTables(ServerConfigurationService.getString((String)"sakai.datawarehouse.dbLoader.properties.alterTables", (String)this.propertiesHandler.properties.getAlterTables()));
            this.propertiesHandler.properties.setIndexTables(ServerConfigurationService.getString((String)"sakai.datawarehouse.dbLoader.properties.indexTables", (String)this.propertiesHandler.properties.getIndexTables()));
            this.propertiesHandler.properties.setPopulateTables(ServerConfigurationService.getString((String)"sakai.datawarehouse.dbLoader.properties.populateTables", (String)this.propertiesHandler.properties.getPopulateTables()));
            this.propertiesHandler.properties.setCreateTableScript(ServerConfigurationService.getString((String)"sakai.datawarehouse.dbLoader.properties.createTableScript", (String)this.propertiesHandler.properties.getCreateTableScript()));
            this.propertiesHandler.properties.setTableScriptFileName(ServerConfigurationService.getString((String)"sakai.datawarehouse.dbLoader.properties.tableScriptFileName", (String)this.propertiesHandler.properties.getTableScriptFileName()));
            this.printInfo();
            this.dropTables = Boolean.valueOf(this.propertiesHandler.properties.getDropTables());
            this.createTables = Boolean.valueOf(this.propertiesHandler.properties.getCreateTables());
            this.populateTables = Boolean.valueOf(this.propertiesHandler.properties.getPopulateTables());
            this.alterTables = Boolean.valueOf(this.propertiesHandler.properties.getAlterTables());
            this.indexTables = Boolean.valueOf(this.propertiesHandler.properties.getIndexTables());
            this.createTableScript = Boolean.valueOf(this.propertiesHandler.properties.getCreateTableScript());
            if (this.createTableScript) {
                this.initTableScript();
            }
            boolean usetable = false;
            boolean usedata = false;
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder domParser = dbf.newDocumentBuilder();
                this.tablesDoc = domParser.parse(new InputSource(tables));
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.tablesDocGeneric = (Document)this.tablesDoc.cloneNode(true);
            this.replaceDataTypes(this.tablesDoc);
            try {
                SAXResult xmlResult = new SAXResult(TableHandlerFactory.getTableHandler(this));
                DOMSource xmlSource = new DOMSource(this.tablesDoc);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream("tables.xsl")));
                transformer.transform(xmlSource, xmlResult);
            }
            catch (TransformerException te) {
                throw new RuntimeException(te);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected XMLReader getXMLReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        return spf.newSAXParser().getXMLReader();
    }

    protected void printInfo() throws SQLException {
        DatabaseMetaData dbMetaData = this.con.getMetaData();
        this.dbName = dbMetaData.getDatabaseProductName();
        this.dbVersion = dbMetaData.getDatabaseProductVersion();
        this.driverName = dbMetaData.getDriverName();
        this.driverVersion = dbMetaData.getDriverVersion();
        this.logger.debug((Object)"Starting DbLoader...");
        this.logger.debug((Object)("Database name: '" + this.dbName + "'"));
        this.logger.debug((Object)("Database version: '" + this.dbVersion + "'"));
        this.logger.debug((Object)("Driver name: '" + this.driverName + "'"));
        this.logger.debug((Object)("Driver version: '" + this.driverVersion + "'"));
        this.logger.debug((Object)("Database url: '" + dbMetaData.getURL() + "'"));
    }

    protected void initTableScript() throws IOException {
        String scriptFileName = System.getProperty("sakai.home") + this.propertiesHandler.properties.getTableScriptFileName();
        String initProperty = "sakai.dw.initializedTables";
        String inited = System.getProperty(initProperty);
        if (inited == null) {
            System.getProperties().setProperty(initProperty, "true");
            File scriptFile = new File(scriptFileName);
            if (scriptFile.exists()) {
                scriptFile.delete();
            }
        }
        this.tableScriptOut = new PrintWriter((Writer)new BufferedWriter(new FileWriter(scriptFileName, true)), true);
    }

    protected void replaceDataTypes(Document tablesDoc) {
        Element tables = tablesDoc.getDocumentElement();
        NodeList types = tables.getElementsByTagName("type");
        for (int i = 0; i < types.getLength(); ++i) {
            Node type = types.item(i);
            NodeList typeChildren = type.getChildNodes();
            for (int j = 0; j < typeChildren.getLength(); ++j) {
                Node text = typeChildren.item(j);
                String genericType = text.getNodeValue();
                text.setNodeValue(this.getLocalDataTypeName(genericType));
            }
        }
    }

    protected int getJavaSqlDataTypeOfColumn(Document tablesDocGeneric, String tableName, String columnName) {
        int dataType = 0;
        String hashKey = tableName + File.separator + columnName;
        if (this.tableColumnTypes.get(hashKey) != null) {
            return (Integer)this.tableColumnTypes.get(hashKey);
        }
        Element table = this.getTableWithName(tablesDocGeneric, tableName);
        Element columns = this.getFirstChildWithName(table, "columns");
        for (Node ch = columns.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            Element name;
            if (!(ch instanceof Element) || !ch.getNodeName().equals("column") || !this.getNodeValue(name = this.getFirstChildWithName((Element)ch, "name")).equals(columnName)) continue;
            Element value = this.getFirstChildWithName((Element)ch, "type");
            dataType = this.getJavaSqlType(this.getNodeValue(value));
        }
        this.tableColumnTypes.put(hashKey, new Integer(dataType));
        return dataType;
    }

    protected Element getFirstChildWithName(Element parent, String name) {
        Element child = null;
        for (Node ch = parent.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element) || !ch.getNodeName().equals(name)) continue;
            child = (Element)ch;
            break;
        }
        return child;
    }

    protected Element getTableWithName(Document tablesDoc, String tableName) {
        Element tableElement = null;
        NodeList tables = tablesDoc.getElementsByTagName("table");
        block0: for (int i = 0; i < tables.getLength(); ++i) {
            Node table = tables.item(i);
            for (Node tableChild = table.getFirstChild(); tableChild != null; tableChild = tableChild.getNextSibling()) {
                if (!(tableChild instanceof Element) || tableChild.getNodeName() == null || !tableChild.getNodeName().equals("name") || !tableName.equals(this.getNodeValue(tableChild))) continue;
                tableElement = (Element)table;
                continue block0;
            }
        }
        return tableElement;
    }

    protected String getNodeValue(Node node) {
        String nodeVal = null;
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Text)) continue;
            nodeVal = ch.getNodeValue();
        }
        return nodeVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocalDataTypeName(String genericDataTypeName) {
        String localDataTypeName = null;
        try {
            DatabaseMetaData dbmd = this.con.getMetaData();
            String dbName = dbmd.getDatabaseProductName();
            String dbVersion = dbmd.getDatabaseProductVersion();
            String driverName = dbmd.getDriverName();
            String driverVersion = dbmd.getDriverVersion();
            localDataTypeName = this.propertiesHandler.properties.getMappedDataTypeName(dbName, dbVersion, driverName, driverVersion, genericDataTypeName);
            if (localDataTypeName != null) {
                return localDataTypeName;
            }
            int dataTypeCode = this.getJavaSqlType(genericDataTypeName);
            ResultSet rs = dbmd.getTypeInfo();
            try {
                while (rs.next()) {
                    int localDataTypeCode = rs.getInt("DATA_TYPE");
                    if (dataTypeCode != localDataTypeCode) continue;
                    try {
                        localDataTypeName = rs.getString("TYPE_NAME");
                    }
                    catch (SQLException sqle) {}
                    break;
                }
            }
            finally {
                rs.close();
            }
            if (localDataTypeName != null) {
                return localDataTypeName;
            }
            this.logger.error((Object)"Error in DbLoader.getLocalDataTypeName()");
            this.logger.error((Object)("Your database driver, '" + driverName + "', version '" + driverVersion + "', was unable to find a local type name that matches the generic type name, '" + genericDataTypeName + "'."));
            this.logger.error((Object)("Please add a mapped type for database '" + dbName + "', version '" + dbVersion + "' inside your properties file and run this program again."));
            this.logger.error((Object)"Exiting...");
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in DbLoader.getLocalDataTypeName()", (Throwable)e);
        }
        return null;
    }

    protected int getJavaSqlType(String genericDataTypeName) {
        int dataTypeCode = 0;
        if (genericDataTypeName.equalsIgnoreCase("BIT")) {
            dataTypeCode = -7;
        } else if (genericDataTypeName.equalsIgnoreCase("TINYINT")) {
            dataTypeCode = -6;
        } else if (genericDataTypeName.equalsIgnoreCase("SMALLINT")) {
            dataTypeCode = 5;
        } else if (genericDataTypeName.equalsIgnoreCase("INTEGER")) {
            dataTypeCode = 4;
        } else if (genericDataTypeName.equalsIgnoreCase("BIGINT")) {
            dataTypeCode = -5;
        } else if (genericDataTypeName.equalsIgnoreCase("FLOAT")) {
            dataTypeCode = 6;
        } else if (genericDataTypeName.equalsIgnoreCase("REAL")) {
            dataTypeCode = 7;
        } else if (genericDataTypeName.equalsIgnoreCase("DOUBLE")) {
            dataTypeCode = 8;
        } else if (genericDataTypeName.equalsIgnoreCase("NUMERIC")) {
            dataTypeCode = 2;
        } else if (genericDataTypeName.equalsIgnoreCase("DECIMAL")) {
            dataTypeCode = 3;
        } else if (genericDataTypeName.equalsIgnoreCase("CHAR")) {
            dataTypeCode = 1;
        } else if (genericDataTypeName.equalsIgnoreCase("VARCHAR")) {
            dataTypeCode = 12;
        } else if (genericDataTypeName.equalsIgnoreCase("LONGVARCHAR")) {
            dataTypeCode = -1;
        } else if (genericDataTypeName.equalsIgnoreCase("DATE")) {
            dataTypeCode = 91;
        } else if (genericDataTypeName.equalsIgnoreCase("TIME")) {
            dataTypeCode = 92;
        } else if (genericDataTypeName.equalsIgnoreCase("TIMESTAMP")) {
            dataTypeCode = 93;
        } else if (genericDataTypeName.equalsIgnoreCase("BINARY")) {
            dataTypeCode = -2;
        } else if (genericDataTypeName.equalsIgnoreCase("VARBINARY")) {
            dataTypeCode = -3;
        } else if (genericDataTypeName.equalsIgnoreCase("LONGVARBINARY")) {
            dataTypeCode = -4;
        } else if (genericDataTypeName.equalsIgnoreCase("NULL")) {
            dataTypeCode = 0;
        } else if (genericDataTypeName.equalsIgnoreCase("OTHER")) {
            dataTypeCode = 1111;
        } else if (genericDataTypeName.equalsIgnoreCase("JAVA_OBJECT")) {
            dataTypeCode = 2000;
        } else if (genericDataTypeName.equalsIgnoreCase("DISTINCT")) {
            dataTypeCode = 2001;
        } else if (genericDataTypeName.equalsIgnoreCase("STRUCT")) {
            dataTypeCode = 2002;
        } else if (genericDataTypeName.equalsIgnoreCase("ARRAY")) {
            dataTypeCode = 2003;
        } else if (genericDataTypeName.equalsIgnoreCase("BLOB")) {
            dataTypeCode = 2004;
        } else if (genericDataTypeName.equalsIgnoreCase("CLOB")) {
            dataTypeCode = 2005;
        } else if (genericDataTypeName.equalsIgnoreCase("REF")) {
            dataTypeCode = 2006;
        }
        return dataTypeCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTable(String dropTableStatement) {
        if (this.createTableScript) {
            this.tableScriptOut.println(dropTableStatement + this.propertiesHandler.properties.getStatementTerminator());
        } else {
            try {
                this.stmt = this.con.createStatement();
                try {
                    this.stmt.executeUpdate(dropTableStatement);
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Error in DbLoader.dropTable()", (Throwable)e);
            }
            finally {
                try {
                    this.stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTable(String createTableStatement) {
        if (this.createTableScript) {
            this.tableScriptOut.println(createTableStatement + this.propertiesHandler.properties.getStatementTerminator());
        } else {
            try {
                this.stmt = this.con.createStatement();
                this.stmt.executeUpdate(createTableStatement);
            }
            catch (Exception e) {
                this.logger.error((Object)("error creating table with this sql: " + createTableStatement));
                this.logger.error((Object)"", (Throwable)e);
            }
            finally {
                try {
                    this.stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alterTable(String alterTableStatement) {
        if (this.createTableScript) {
            this.tableScriptOut.println(alterTableStatement + this.propertiesHandler.properties.getStatementTerminator());
        } else {
            try {
                this.stmt = this.con.createStatement();
                this.stmt.executeUpdate(alterTableStatement);
            }
            catch (Exception e) {
                this.logger.error((Object)("error altering table with this sql: " + alterTableStatement));
                this.logger.error((Object)"", (Throwable)e);
            }
            finally {
                try {
                    this.stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexTable(String indexTableStatement) {
        if (this.createTableScript) {
            this.tableScriptOut.println(indexTableStatement + this.propertiesHandler.properties.getStatementTerminator());
        } else {
            try {
                this.stmt = this.con.createStatement();
                this.stmt.executeUpdate(indexTableStatement);
            }
            catch (Exception e) {
                this.logger.error((Object)("error indexing table with this sql: " + indexTableStatement));
                this.logger.error((Object)"", (Throwable)e);
            }
            finally {
                try {
                    this.stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void readProperties(XMLReader parser, InputStream properties) throws SAXException, IOException {
        this.propertiesHandler = new PropertiesHandler();
        parser.setContentHandler(this.propertiesHandler);
        parser.setErrorHandler(this.propertiesHandler);
        parser.parse(new InputSource(properties));
    }

    public Connection getCon() {
        return this.con;
    }

    public void setCon(Connection con) {
        this.con = con;
    }

    public Statement getStmt() {
        return this.stmt;
    }

    public void setStmt(Statement stmt) {
        this.stmt = stmt;
    }

    public PreparedStatement getPstmt() {
        return this.pstmt;
    }

    public void setPstmt(PreparedStatement pstmt) {
        this.pstmt = pstmt;
    }

    public Document getTablesDoc() {
        return this.tablesDoc;
    }

    public void setTablesDoc(Document tablesDoc) {
        this.tablesDoc = tablesDoc;
    }

    public Document getTablesDocGeneric() {
        return this.tablesDocGeneric;
    }

    public void setTablesDocGeneric(Document tablesDocGeneric) {
        this.tablesDocGeneric = tablesDocGeneric;
    }

    public boolean isCreateTableScript() {
        return this.createTableScript;
    }

    public void setCreateTableScript(boolean createTableScript) {
        this.createTableScript = createTableScript;
    }

    public boolean isPopulateTables() {
        return this.populateTables;
    }

    public void setPopulateTables(boolean populateTables) {
        this.populateTables = populateTables;
    }

    public PrintWriter getTableScriptOut() {
        return this.tableScriptOut;
    }

    public void setTableScriptOut(PrintWriter tableScriptOut) {
        this.tableScriptOut = tableScriptOut;
    }

    public boolean isDropTables() {
        return this.dropTables;
    }

    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }

    public boolean isCreateTables() {
        return this.createTables;
    }

    public void setCreateTables(boolean createTables) {
        this.createTables = createTables;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public boolean isAlterTables() {
        return this.alterTables;
    }

    public void setAlterTables(boolean alterTables) {
        this.alterTables = alterTables;
    }

    public boolean isIndexTables() {
        return this.indexTables;
    }

    public void setIndexTables(boolean indexTables) {
        this.indexTables = indexTables;
    }

    public Hashtable getTableColumnTypes() {
        return this.tableColumnTypes;
    }

    public void setTableColumnTypes(Hashtable tableColumnTypes) {
        this.tableColumnTypes = tableColumnTypes;
    }

    public PropertiesHandler getPropertiesHandler() {
        return this.propertiesHandler;
    }

    public void setPropertiesHandler(PropertiesHandler propertiesHandler) {
        this.propertiesHandler = propertiesHandler;
    }

    class DataHandler
    extends DefaultHandler {
        protected StringBuilder charBuff = null;
        protected boolean insideData = false;
        private boolean insideTable = false;
        private boolean insideName = false;
        private boolean insideRow = false;
        private boolean insideColumn = false;
        private boolean insideValue = false;
        private boolean supportsPreparedStatements = false;
        Table table;
        Row row;
        Column column;
        String action;
        String type;

        DataHandler() {
        }

        @Override
        public void startDocument() {
            DbLoader.this.logger.debug((Object)"Populating tables...");
            if (!DbLoader.this.populateTables) {
                DbLoader.this.logger.debug((Object)"disabled.");
            }
            this.supportsPreparedStatements = this.supportsPreparedStatements();
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.charBuff = new StringBuilder();
            if (qName.equals("data")) {
                this.insideData = true;
            } else if (qName.equals("table")) {
                this.insideTable = true;
                this.table = new Table();
                this.action = atts.getValue("action");
            } else if (qName.equals("name")) {
                this.insideName = true;
            } else if (qName.equals("row")) {
                this.insideRow = true;
                this.row = new Row();
            } else if (qName.equals("column")) {
                this.insideColumn = true;
                this.column = new Column();
                this.type = atts.getValue("type");
            } else if (qName.equals("value")) {
                this.insideValue = true;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("data")) {
                this.insideData = false;
            } else if (qName.equals("table")) {
                this.insideTable = false;
            } else if (qName.equals("name")) {
                this.insideName = false;
                if (!this.insideColumn) {
                    this.table.setName(this.charBuff.toString().toLowerCase());
                } else {
                    this.column.setName(this.charBuff.toString());
                }
            } else if (qName.equals("row")) {
                this.insideRow = false;
                if (this.action != null) {
                    if (this.action.equals("delete")) {
                        this.executeSQL(this.table, this.row, "delete");
                    } else if (this.action.equals("modify")) {
                        this.executeSQL(this.table, this.row, "modify");
                    } else if (this.action.equals("add")) {
                        this.executeSQL(this.table, this.row, "insert");
                    }
                } else if (DbLoader.this.populateTables) {
                    this.executeSQL(this.table, this.row, "insert");
                }
            } else if (qName.equals("column")) {
                this.insideColumn = false;
                if (this.type != null) {
                    this.column.setType(this.type);
                }
                this.row.addColumn(this.column);
            } else if (qName.equals("value")) {
                this.insideValue = false;
                if (this.insideColumn) {
                    this.column.setValue(this.charBuff.toString());
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.charBuff.append(ch, start, length);
        }

        private String prepareInsertStatement(Row row, boolean preparedStatement) {
            StringBuilder sb = new StringBuilder("INSERT INTO ");
            sb.append(this.table.getName()).append(" (");
            ArrayList columns = row.getColumns();
            for (Column column : columns) {
                sb.append(column.getName()).append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") VALUES (");
            for (Column column : columns) {
                if (preparedStatement) {
                    sb.append("?");
                } else {
                    String value = column.getValue();
                    if (value != null) {
                        if (value.equals("SYSDATE")) {
                            sb.append(value);
                        } else if (value.equals("NULL")) {
                            sb.append(value);
                        } else if (DbLoader.this.getJavaSqlDataTypeOfColumn(DbLoader.this.tablesDocGeneric, this.table.getName(), column.getName()) == 4) {
                            sb.append(value);
                        } else {
                            sb.append("'");
                            sb.append(this.sqlEscape(value.trim()));
                            sb.append("'");
                        }
                    } else {
                        sb.append("''");
                    }
                }
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            return sb.toString();
        }

        private String prepareDeleteStatement(Row row, boolean preparedStatement) {
            StringBuilder sb = new StringBuilder("DELETE FROM ");
            sb.append(this.table.getName()).append(" WHERE ");
            ArrayList columns = row.getColumns();
            for (Column column : columns) {
                if (preparedStatement) {
                    sb.append(column.getName() + " = ? and ");
                    continue;
                }
                if (DbLoader.this.getJavaSqlDataTypeOfColumn(DbLoader.this.tablesDocGeneric, this.table.getName(), column.getName()) == 4) {
                    sb.append(column.getName() + " = " + this.sqlEscape(column.getValue().trim()) + " and ");
                    continue;
                }
                sb.append(column.getName() + " = " + "'" + this.sqlEscape(column.getValue().trim()) + "' and ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            if (!preparedStatement) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        private String prepareUpdateStatement(Row row, boolean preparedStatement) {
            String val;
            String nm;
            StringBuilder sb = new StringBuilder("UPDATE ");
            sb.append(this.table.getName()).append(" SET ");
            ArrayList columns = row.getColumns();
            Iterator iterator = columns.iterator();
            Hashtable<String, String> setPairs = new Hashtable<String, String>();
            Hashtable<String, String> wherePairs = new Hashtable<String, String>();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                String type = column.getType();
                if (type != null && type.equals("select")) {
                    if (DbLoader.this.getJavaSqlDataTypeOfColumn(DbLoader.this.tablesDocGeneric, this.table.getName(), column.getName()) == 4) {
                        wherePairs.put(column.getName(), column.getValue().trim());
                        continue;
                    }
                    wherePairs.put(column.getName(), "'" + column.getValue().trim() + "'");
                    continue;
                }
                if (DbLoader.this.getJavaSqlDataTypeOfColumn(DbLoader.this.tablesDocGeneric, this.table.getName(), column.getName()) == 4) {
                    setPairs.put(column.getName(), column.getValue().trim());
                    continue;
                }
                setPairs.put(column.getName(), "'" + column.getValue().trim() + "'");
            }
            Enumeration sKeys = setPairs.keys();
            while (sKeys.hasMoreElements()) {
                nm = (String)sKeys.nextElement();
                val = (String)setPairs.get(nm);
                sb.append(nm + " = " + this.sqlEscape(val) + ", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" WHERE ");
            Enumeration wKeys = wherePairs.keys();
            while (wKeys.hasMoreElements()) {
                nm = (String)wKeys.nextElement();
                val = (String)wherePairs.get(nm);
                sb.append(nm + "=" + this.sqlEscape(val) + " and ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        public final String sqlEscape(String sql) {
            if (sql == null) {
                return "";
            }
            int primePos = sql.indexOf("'");
            if (primePos == -1) {
                return sql;
            }
            StringBuilder sb = new StringBuilder(sql.length() + 4);
            int startPos = 0;
            do {
                sb.append(sql.substring(startPos, primePos + 1));
                sb.append("'");
            } while ((primePos = sql.indexOf("'", startPos = primePos + 1)) != -1);
            sb.append(sql.substring(startPos));
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeSQL(Table table, Row row, String action) {
            if (DbLoader.this.createTableScript) {
                if (action.equals("delete")) {
                    DbLoader.this.tableScriptOut.println(this.prepareDeleteStatement(row, false) + DbLoader.this.propertiesHandler.properties.getStatementTerminator());
                } else if (action.equals("modify")) {
                    DbLoader.this.tableScriptOut.println(this.prepareUpdateStatement(row, false) + DbLoader.this.propertiesHandler.properties.getStatementTerminator());
                } else if (action.equals("insert")) {
                    DbLoader.this.tableScriptOut.println(this.prepareInsertStatement(row, false) + DbLoader.this.propertiesHandler.properties.getStatementTerminator());
                }
            }
            if (this.supportsPreparedStatements) {
                String preparedStatement = "";
                try {
                    if (action.equals("delete")) {
                        preparedStatement = this.prepareDeleteStatement(row, true);
                    } else if (action.equals("modify")) {
                        preparedStatement = this.prepareUpdateStatement(row, true);
                    } else if (action.equals("insert")) {
                        preparedStatement = this.prepareInsertStatement(row, true);
                    }
                    DbLoader.this.pstmt = DbLoader.this.con.prepareStatement(preparedStatement);
                    DbLoader.this.pstmt.clearParameters();
                    ArrayList columns = row.getColumns();
                    Iterator iterator = columns.iterator();
                    int i = 1;
                    while (iterator.hasNext()) {
                        Column column = (Column)iterator.next();
                        String value = column.getValue();
                        int javaSqlDataType = DbLoader.this.getJavaSqlDataTypeOfColumn(DbLoader.this.tablesDocGeneric, table.getName(), column.getName());
                        if (value == null || value != null && value.equalsIgnoreCase("NULL")) {
                            DbLoader.this.pstmt.setNull(i, javaSqlDataType);
                        } else if (javaSqlDataType == 93) {
                            if (value.equals("SYSDATE")) {
                                DbLoader.this.pstmt.setTimestamp(i, new Timestamp(System.currentTimeMillis()));
                            } else {
                                DbLoader.this.pstmt.setTimestamp(i, Timestamp.valueOf(value));
                            }
                        } else {
                            int valueLength = (value = value.trim()).length();
                            if (valueLength <= 4000) {
                                try {
                                    DbLoader.this.pstmt.setObject(i, (Object)value, javaSqlDataType);
                                }
                                catch (Exception e) {
                                    DbLoader.this.pstmt.setObject(i, value);
                                }
                            } else {
                                try {
                                    try {
                                        DbLoader.this.pstmt.setObject(i, (Object)value, javaSqlDataType);
                                    }
                                    catch (Exception e) {
                                        DbLoader.this.pstmt.setObject(i, value);
                                    }
                                }
                                catch (SQLException sqle) {
                                    DbLoader.this.pstmt.setCharacterStream(i, (Reader)new StringReader(value), valueLength);
                                }
                            }
                        }
                        ++i;
                    }
                    DbLoader.this.pstmt.executeUpdate();
                }
                catch (SQLException sqle) {
                    DbLoader.this.logger.error((Object)"Error in DbLoader.DataHandler.executeSQL()", (Throwable)sqle);
                    DbLoader.this.logger.error((Object)("Error in DbLoader.DataHandler.executeSQL(): " + preparedStatement));
                }
                catch (Exception e) {
                    DbLoader.this.logger.error((Object)"Error in DbLoader.DataHandler.executeSQL()", (Throwable)e);
                }
                finally {
                    try {
                        DbLoader.this.pstmt.close();
                    }
                    catch (Exception e) {}
                }
            } else {
                String statement = "";
                if (action.equals("delete")) {
                    statement = this.prepareDeleteStatement(row, false);
                } else if (action.equals("modify")) {
                    statement = this.prepareUpdateStatement(row, false);
                } else if (action.equals("insert")) {
                    statement = this.prepareInsertStatement(row, false);
                }
                try {
                    DbLoader.this.stmt = DbLoader.this.con.createStatement();
                    DbLoader.this.stmt.executeUpdate(statement);
                }
                catch (Exception e) {
                    DbLoader.this.logger.error((Object)"Error in DbLoader.DataHandler.executeSQL()", (Throwable)e);
                    DbLoader.this.logger.error((Object)("Error in DbLoader.DataHandler.executeSQL(): " + statement));
                }
                finally {
                    try {
                        DbLoader.this.stmt.close();
                    }
                    catch (Exception e) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean supportsPreparedStatements() {
            boolean supportsPreparedStatements = true;
            try {
                Statement stmt = DbLoader.this.con.createStatement();
                try {
                    stmt.executeUpdate("CREATE TABLE PREP_TEST (A VARCHAR(1))");
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
                DbLoader.this.pstmt = DbLoader.this.con.prepareStatement("SELECT A FROM PREP_TEST WHERE A=?");
                DbLoader.this.pstmt.clearParameters();
                DbLoader.this.pstmt.setString(1, "D");
                ResultSet rs = DbLoader.this.pstmt.executeQuery();
                rs.close();
            }
            catch (SQLException sqle) {
                supportsPreparedStatements = false;
                DbLoader.this.logger.error((Object)"Error in DbLoader.DataHandler.supportsPreparedStatements()", (Throwable)sqle);
            }
            finally {
                block54: {
                    DbLoader.this.stmt = DbLoader.this.con.createStatement();
                    DbLoader.this.stmt.executeUpdate("DROP TABLE PREP_TEST");
                    try {
                        DbLoader.this.stmt.close();
                    }
                    catch (Exception e) {}
                    break block54;
                    catch (Exception e) {
                        try {
                            DbLoader.this.stmt.close();
                        }
                        catch (Exception e2) {}
                        catch (Throwable throwable) {
                            try {
                                DbLoader.this.stmt.close();
                            }
                            catch (Exception e3) {}
                            throw throwable;
                        }
                    }
                }
                try {
                    DbLoader.this.pstmt.close();
                }
                catch (Exception exception) {}
            }
            return supportsPreparedStatements;
        }

        class Column {
            private String name;
            private String value;
            private String type;

            Column() {
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public String getType() {
                return this.type;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public void setType(String type) {
                this.type = type;
            }
        }

        class Row {
            ArrayList columns = new ArrayList();

            Row() {
            }

            public ArrayList getColumns() {
                return this.columns;
            }

            public void addColumn(Column column) {
                this.columns.add(column);
            }
        }

        class Table {
            private String name;

            Table() {
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }

    private class PropertiesHandler
    extends DefaultHandler {
        private StringBuilder charBuff = null;
        private Properties properties;
        private DbTypeMapping dbTypeMapping;
        private Type type;

        private PropertiesHandler() {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.charBuff = new StringBuilder();
            if (qName.equals("properties")) {
                this.properties = new Properties();
            } else if (qName.equals("db-type-mapping")) {
                this.dbTypeMapping = new DbTypeMapping();
            } else if (qName.equals("type")) {
                this.type = new Type();
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("drop-tables")) {
                this.properties.setDropTables(this.charBuff.toString());
            } else if (qName.equals("create-tables")) {
                this.properties.setCreateTables(this.charBuff.toString());
            } else if (qName.equals("populate-tables")) {
                this.properties.setPopulateTables(this.charBuff.toString());
            } else if (qName.equals("create-table-script")) {
                this.properties.setCreateTableScript(this.charBuff.toString());
            } else if (qName.equals("table-script-file-name")) {
                this.properties.setTableScriptFileName(this.charBuff.toString());
            } else if (qName.equals("statement-terminator")) {
                this.properties.setStatementTerminator(this.charBuff.toString());
            } else if (qName.equals("db-type-mapping")) {
                this.properties.addDbTypeMapping(this.dbTypeMapping);
            } else if (qName.equals("db-name")) {
                this.dbTypeMapping.setDbName(this.charBuff.toString());
            } else if (qName.equals("db-version")) {
                this.dbTypeMapping.setDbVersion(this.charBuff.toString());
            } else if (qName.equals("driver-name")) {
                this.dbTypeMapping.setDriverName(this.charBuff.toString());
            } else if (qName.equals("driver-version")) {
                this.dbTypeMapping.setDriverVersion(this.charBuff.toString());
            } else if (qName.equals("type")) {
                this.dbTypeMapping.addType(this.type);
            } else if (qName.equals("generic")) {
                this.type.setGeneric(this.charBuff.toString());
            } else if (qName.equals("local")) {
                this.type.setLocal(this.charBuff.toString());
            } else if (qName.equals("alter-tables")) {
                this.properties.setAlterTables(this.charBuff.toString());
            } else if (qName.equals("index-tables")) {
                this.properties.setIndexTables(this.charBuff.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.charBuff.append(ch, start, length);
        }

        class Type {
            String genericType;
            String local;

            Type() {
            }

            public String getGeneric() {
                return this.genericType;
            }

            public String getLocal() {
                return this.local;
            }

            public void setGeneric(String genericType) {
                this.genericType = genericType;
            }

            public void setLocal(String local) {
                this.local = local;
            }
        }

        class DbTypeMapping {
            String dbName;
            String dbVersion;
            String driverName;
            String driverVersion;
            ArrayList types = new ArrayList();

            DbTypeMapping() {
            }

            public String getDbName() {
                return this.dbName;
            }

            public String getDbVersion() {
                return this.dbVersion;
            }

            public String getDriverName() {
                return this.driverName;
            }

            public String getDriverVersion() {
                return this.driverVersion;
            }

            public ArrayList getTypes() {
                return this.types;
            }

            public void setDbName(String dbName) {
                this.dbName = dbName;
            }

            public void setDbVersion(String dbVersion) {
                this.dbVersion = dbVersion;
            }

            public void setDriverName(String driverName) {
                this.driverName = driverName;
            }

            public void setDriverVersion(String driverVersion) {
                this.driverVersion = driverVersion;
            }

            public void addType(Type type) {
                this.types.add(type);
            }

            public String getMappedDataTypeName(String genericDataTypeName) {
                String mappedDataTypeName = null;
                for (Type type : this.types) {
                    if (!type.getGeneric().equalsIgnoreCase(genericDataTypeName)) continue;
                    mappedDataTypeName = type.getLocal();
                }
                return mappedDataTypeName;
            }
        }

        class Properties {
            private String dropTables;
            private String createTables;
            private String populateTables;
            private String createTableScript;
            private String tableScriptFileName;
            private String statementTerminator;
            private ArrayList dbTypeMappings = new ArrayList();
            private String alterTables;
            private String indexTables;

            Properties() {
            }

            public String getDropTables() {
                return this.dropTables;
            }

            public String getCreateTables() {
                return this.createTables;
            }

            public String getPopulateTables() {
                return this.populateTables;
            }

            public String getCreateTableScript() {
                return this.createTableScript;
            }

            public String getTableScriptFileName() {
                return this.tableScriptFileName;
            }

            public String getStatementTerminator() {
                return this.statementTerminator;
            }

            public ArrayList getDbTypeMappings() {
                return this.dbTypeMappings;
            }

            public void setDropTables(String dropTables) {
                this.dropTables = dropTables;
            }

            public void setCreateTables(String createTables) {
                this.createTables = createTables;
            }

            public void setPopulateTables(String populateTables) {
                this.populateTables = populateTables;
            }

            public void setCreateTableScript(String createTableScript) {
                this.createTableScript = createTableScript;
            }

            public void setTableScriptFileName(String tableScriptFileName) {
                this.tableScriptFileName = tableScriptFileName;
            }

            public void setStatementTerminator(String statementTerminator) {
                this.statementTerminator = statementTerminator;
            }

            public void addDbTypeMapping(DbTypeMapping dbTypeMapping) {
                this.dbTypeMappings.add(dbTypeMapping);
            }

            public String getAlterTables() {
                return this.alterTables;
            }

            public void setAlterTables(String alterTables) {
                this.alterTables = alterTables;
            }

            public String getIndexTables() {
                return this.indexTables;
            }

            public void setIndexTables(String indexTables) {
                this.indexTables = indexTables;
            }

            public String getMappedDataTypeName(String dbName, String dbVersion, String driverName, String driverVersion, String genericDataTypeName) {
                String mappedDataTypeName = null;
                for (DbTypeMapping dbTypeMapping : this.dbTypeMappings) {
                    String dbNameProp = dbTypeMapping.getDbName();
                    String dbVersionProp = dbTypeMapping.getDbVersion();
                    String driverNameProp = dbTypeMapping.getDriverName();
                    String driverVersionProp = dbTypeMapping.getDriverVersion();
                    if (!dbNameProp.equalsIgnoreCase(dbName) || !dbVersionProp.equalsIgnoreCase(dbVersion) || !driverNameProp.equalsIgnoreCase(driverName) || !driverVersionProp.equalsIgnoreCase(driverVersion)) continue;
                    mappedDataTypeName = dbTypeMapping.getMappedDataTypeName(genericDataTypeName);
                }
                return mappedDataTypeName;
            }
        }
    }
}

