/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.util.db;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.warehouse.util.db.DbLoader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MySqlHandler
implements ContentHandler {
    private static final int UNSET = -1;
    private static final int DROP = 0;
    private static final int CREATE = 1;
    private static final int ALTER = 2;
    private static final int INDEX = 3;
    private static int mode = -1;
    private static StringBuilder stmtBuffer;
    private int treeLevel;
    private String tmpType;
    private String tmpParm;
    private DbLoader loader;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public MySqlHandler(DbLoader loader) {
        this.logger.debug((Object)"MySQL table handler...");
        this.loader = loader;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (qName.equals("statement")) {
            this.tmpType = "";
            this.tmpParm = "";
            this.treeLevel = 0;
            stmtBuffer = new StringBuilder(1024);
            String statementType = atts.getValue("type");
            if (mode == -1 || mode != 0 && statementType != null && statementType.equals("drop")) {
                mode = 0;
                this.logger.debug((Object)"Dropping tables...");
                if (!this.loader.isDropTables()) {
                    this.logger.debug((Object)"disabled.");
                }
            } else if (mode == -1 || mode != 1 && statementType != null && statementType.equals("create")) {
                mode = 1;
                this.logger.debug((Object)"Creating tables...");
                if (!this.loader.isCreateTables()) {
                    this.logger.debug((Object)"disabled.");
                }
            } else if (mode == -1 || mode != 2 && statementType != null && statementType.equals("alter")) {
                mode = 2;
                this.logger.debug((Object)"Altering tables...");
                if (!this.loader.isAlterTables()) {
                    this.logger.debug((Object)"disabled.");
                }
            } else if (mode == -1 || mode != 3 && statementType != null && statementType.equals("index")) {
                mode = 3;
                this.logger.debug((Object)"Indexing tables...");
                if (!this.loader.isIndexTables()) {
                    this.logger.debug((Object)"disabled.");
                }
            }
        }
        if (qName.equals("column-type")) {
            ++this.treeLevel;
            this.tmpType = "";
        }
        if (qName.equals("type-param")) {
            ++this.treeLevel;
            this.tmpParm = "";
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (qName.equals("statement")) {
            this.treeLevel = 0;
            String statement = stmtBuffer.toString();
            switch (mode) {
                case 0: {
                    if (!this.loader.isDropTables()) break;
                    statement = statement + " CASCADE";
                    this.loader.dropTable(statement);
                    break;
                }
                case 1: {
                    if (!this.loader.isCreateTables()) break;
                    this.loader.createTable(statement);
                    break;
                }
                case 2: {
                    if (!this.loader.isAlterTables()) break;
                    this.loader.alterTable(statement);
                    break;
                }
                case 3: {
                    if (!this.loader.isIndexTables()) break;
                    this.loader.indexTable(statement);
                    break;
                }
            }
        }
        if (qName.equals("column-type")) {
            --this.treeLevel;
        }
        if (qName.equals("type-param")) {
            --this.treeLevel;
        }
        if (this.treeLevel == 0) {
            this.parseParamToDatabase();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.treeLevel == 0) {
            stmtBuffer.append(ch, start, length);
        } else if (this.treeLevel == 1) {
            this.tmpType = new String(ch, start, length);
        } else if (this.treeLevel == 2) {
            this.tmpParm = new String(ch, start, length);
        }
    }

    private void parseParamToDatabase() {
        int parm = 0;
        if (this.tmpParm != null && this.tmpParm.length() > 0) {
            parm = Integer.parseInt(this.tmpParm);
            if (this.tmpType.equals("VARCHAR")) {
                if (parm >= 256) {
                    stmtBuffer.append("TEXT");
                } else {
                    stmtBuffer.append(this.tmpType.trim());
                    stmtBuffer.append("(" + this.tmpParm.trim() + ")");
                }
            } else {
                stmtBuffer.append(this.tmpType.trim());
                stmtBuffer.append("(" + this.tmpParm.trim() + ")");
            }
        } else {
            stmtBuffer.append(this.tmpType.trim());
        }
        this.tmpParm = "";
        this.tmpType = "";
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

