/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;
import org.sakaiproject.warehouse.service.ChildWarehouseTask;
import org.sakaiproject.warehouse.service.DataWarehouseManager;
import org.sakaiproject.warehouse.service.WarehouseTask;
import org.sakaiproject.warehouse.util.db.DbLoader;

public abstract class BaseWarehouseTask
implements WarehouseTask {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private ChildWarehouseTask task;
    private String tableDdlResource;
    private DataWarehouseManager dataWarehouseManager;

    public void execute() throws JobExecutionException {
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            connection.setAutoCommit(true);
            this.task.prepare(connection);
            this.task.execute(null, this.getItems(), connection);
        }
        catch (SQLException e) {
            throw new JobExecutionException((Throwable)e);
        }
        catch (JobExecutionException e) {
            this.logger.warn((Object)"Error executing warehousing tasks", (Throwable)e);
            throw e;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void init() {
        this.logger.info((Object)"init()");
        Connection connection = null;
        try {
            InputStream tableDdl;
            if (this.getDataWarehouseManager().isAutoDdl() && (tableDdl = this.getTableDdl()) != null) {
                connection = this.getDataSource().getConnection();
                connection.setAutoCommit(true);
                DbLoader loader = new DbLoader(connection);
                loader.runLoader(tableDdl);
            }
            this.getDataWarehouseManager().registerTask((WarehouseTask)this);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public InputStream getTableDdl() {
        if (this.getTableDdlResource() != null) {
            return this.getClass().getResourceAsStream(this.getTableDdlResource());
        }
        return null;
    }

    protected abstract Collection getItems();

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ChildWarehouseTask getTask() {
        return this.task;
    }

    public void setTask(ChildWarehouseTask task) {
        this.task = task;
    }

    public String getTableDdlResource() {
        return this.tableDdlResource;
    }

    public void setTableDdlResource(String tableDdlResource) {
        this.tableDdlResource = tableDdlResource;
    }

    public DataWarehouseManager getDataWarehouseManager() {
        return this.dataWarehouseManager;
    }

    public void setDataWarehouseManager(DataWarehouseManager dataWarehouseManager) {
        this.dataWarehouseManager = dataWarehouseManager;
    }
}

