/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import org.sakaiproject.metaobj.shared.mgt.ReferenceHolder;
import org.sakaiproject.warehouse.service.PropertyAccess;

public class ReferenceHolderPropertyAccess
implements PropertyAccess {
    private Map gettorMap = new Hashtable();
    private String propertyName;

    public Object getPropertyValue(Object source) throws Exception {
        Method objectMethodGetProperty = this.getPropertyGettor(source);
        if (objectMethodGetProperty == null) {
            throw new NullPointerException(source.getClass().getName() + " has no get for property \"" + this.propertyName + "\"");
        }
        Object value = objectMethodGetProperty.invoke(source, new Object[0]);
        ReferenceHolder refHolder = null;
        try {
            refHolder = (ReferenceHolder)value;
        }
        catch (ClassCastException e) {
            throw new Exception("The source could not be cast into an ReferenceHolder for property \"" + this.propertyName + "\"", e);
        }
        return refHolder.getBase().getId();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Method getPropertyGettor(Object source) throws IntrospectionException {
        Method propertyGettor = (Method)this.gettorMap.get(source.getClass());
        if (propertyGettor == null) {
            BeanInfo info = Introspector.getBeanInfo(source.getClass());
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                if (!descriptors[i].getName().equals(this.getPropertyName())) continue;
                propertyGettor = descriptors[i].getReadMethod();
                this.gettorMap.put(source.getClass(), propertyGettor);
                break;
            }
        }
        return propertyGettor;
    }
}

