/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import org.sakaiproject.warehouse.service.PropertyAccess;

public class BeanPropertyAccess
implements PropertyAccess {
    private Map gettorMap = new Hashtable();
    private String propertyName;

    public Object getPropertyValue(Object source) throws Exception {
        if (source == null) {
            throw new NullPointerException("The source object is null, getting property \"" + this.propertyName + "\"");
        }
        Method objectMethodGetProperty = this.getPropertyGettor(source);
        if (objectMethodGetProperty == null) {
            throw new NullPointerException(source.getClass().getName() + " has no get for property \"" + this.propertyName + "\"");
        }
        return objectMethodGetProperty.invoke(source, new Object[0]);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Method getPropertyGettor(Object source) throws IntrospectionException {
        Method propertyGettor = (Method)this.gettorMap.get(source.getClass());
        if (propertyGettor == null) {
            BeanInfo info = Introspector.getBeanInfo(source.getClass());
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                if (!descriptors[i].getName().equals(this.getPropertyName())) continue;
                propertyGettor = descriptors[i].getReadMethod();
                this.gettorMap.put(source.getClass(), propertyGettor);
                break;
            }
        }
        return propertyGettor;
    }
}

