/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.metaobj.security.impl.AllowAllSecurityAdvisor;
import org.sakaiproject.warehouse.service.DataWarehouseManager;
import org.sakaiproject.warehouse.service.WarehouseTask;

public class DataWarehouseManagerImpl
implements DataWarehouseManager {
    protected final Log logger = LogFactory.getLog(DataWarehouseManagerImpl.class);
    private List tasks;
    private SecurityService securityService;
    private boolean autoDdl = true;

    public void registerTask(WarehouseTask task) {
        this.getTasks().add(task);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.getSecurityService().pushAdvisor((SecurityAdvisor)new AllowAllSecurityAdvisor());
        for (WarehouseTask task : this.getTasks()) {
            try {
                task.execute();
            }
            catch (Exception e) {
                this.logger.error((Object)("problem running dw warehouse task:" + e.getMessage()), (Throwable)e);
            }
        }
        this.getSecurityService().popAdvisor();
    }

    public List getTasks() {
        return this.tasks;
    }

    public void setTasks(List tasks) {
        this.tasks = tasks;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public boolean isAutoDdl() {
        return this.autoDdl;
    }

    public void setAutoDdl(boolean autoDdl) {
        this.autoDdl = autoDdl;
    }
}

