/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.warehouse.sakai.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import org.sakaiproject.db.api.SqlReader;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.warehouse.impl.BaseWarehouseTask;
import org.sakaiproject.warehouse.model.SessionBean;

public class SessionWarehouseTask
extends BaseWarehouseTask {
    private SqlService sqlService;
    private TimeService timeService;

    @Override
    protected Collection getItems() {
        String statement = "select SESSION_ID,SESSION_SERVER,SESSION_USER,SESSION_IP,SESSION_USER_AGENT,SESSION_START,SESSION_END from SAKAI_SESSION";
        List sessions = this.sqlService.dbRead(statement, null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                try {
                    String id = result.getString(1);
                    String server = result.getString(2);
                    String userId = result.getString(3);
                    String ip = result.getString(4);
                    String agent = result.getString(5);
                    Timestamp start = result.getTimestamp(6);
                    Timestamp end = result.getTimestamp(7);
                    SessionBean session = new SessionBean(id, server, userId, ip, agent, start, end);
                    return session;
                }
                catch (SQLException ignore) {
                    return null;
                }
            }
        });
        return sessions;
    }

    public SqlService getSqlService() {
        return this.sqlService;
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }
}

