/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.wicket.component;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.sakaiproject.portal.util.PortalUtils;
import org.sakaiproject.util.DateFormatterUtil;

public class SakaiDateTimeField
extends TextField<ZonedDateTime> {
    private static final String DATEPICKERSCRIPT = "/library/js/lang-datepicker/lang-datepicker.js%s";
    private static final String JQUERYUISCRIPT = "/library/webjars/jquery-ui/1.12.1/jquery-ui.min.js%s";
    private SakaiIsoDateConverter dateConverter;
    private static final String DATEPICKER_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATEPICKER_FORMAT_DATE_ONLY = "yyyy-MM-dd";
    private boolean useTime = true;
    private boolean allowEmptyDate = true;
    private boolean loadJQueryUI = true;
    private final ZoneId zoneId;

    public SakaiDateTimeField(String id, IModel<ZonedDateTime> model, ZoneId timeZoneId) {
        super(id, model);
        Objects.requireNonNull(timeZoneId);
        this.zoneId = timeZoneId;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
        this.dateConverter = new SakaiIsoDateConverter(this.getMarkupId());
        this.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"sakai-datetimefield"))});
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        return ZonedDateTime.class.isAssignableFrom(type) ? this.dateConverter : super.getConverter(type);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String version = PortalUtils.getCDNQuery();
        if (this.loadJQueryUI) {
            response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)String.format(JQUERYUISCRIPT, version)));
        }
        response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)String.format(DATEPICKERSCRIPT, version)));
        String pattern = this.useTime ? DATEPICKER_FORMAT : DATEPICKER_FORMAT_DATE_ONLY;
        String formattedDate = this.getModelObject() == null ? "" : ((ZonedDateTime)this.getModelObject()).format(DateTimeFormatter.ofPattern(pattern, this.getSession().getLocale()));
        String script = String.format("SDP.initSakaiDatePicker('%s','%s', %b, %b);", this.getMarkupId(), formattedDate, this.useTime, this.allowEmptyDate);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
    }

    public SakaiDateTimeField setUseTime(boolean value) {
        this.useTime = value;
        return this;
    }

    public SakaiDateTimeField setAllowEmptyDate(boolean value) {
        this.allowEmptyDate = value;
        return this;
    }

    public SakaiDateTimeField setLoadJQueryUI(boolean value) {
        this.loadJQueryUI = value;
        return this;
    }

    private class SakaiIsoDateConverter
    implements IConverter<ZonedDateTime> {
        private final String componentMarkupId;

        public SakaiIsoDateConverter(String componentMarkupId) {
            this.componentMarkupId = componentMarkupId;
        }

        public ZonedDateTime convertToObject(String string, Locale locale) throws ConversionException {
            String isoParam = this.componentMarkupId + "ISO8601";
            String isoDateStr = SakaiDateTimeField.this.getRequest().getRequestParameters().getParameterValue(isoParam).toString("");
            if (!DateFormatterUtil.isValidISODate((String)isoDateStr)) {
                throw new ConversionException("Invalid ISO date: " + isoDateStr).setResourceKey("sakaidatetimefield.error.dateformat");
            }
            LocalDateTime local = LocalDateTime.parse(isoDateStr, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return ZonedDateTime.of(local, SakaiDateTimeField.this.zoneId);
        }

        public String convertToString(ZonedDateTime c, Locale locale) {
            return "";
        }
    }
}

