/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie;

import java.util.Iterator;
import java.util.Map;
import org.sapia.archie.DuplicateException;
import org.sapia.archie.Name;
import org.sapia.archie.NameParser;
import org.sapia.archie.NamePart;
import org.sapia.archie.Node;
import org.sapia.archie.NodeFactory;
import org.sapia.archie.ProcessingException;
import org.sapia.archie.impl.DefaultNameParser;

public abstract class AbstractNode
implements Node {
    protected Map _children;
    protected NodeFactory _fac;
    private NamePart _name;
    private Name _absolutePath = new Name();
    private Node _parent;
    private NameParser _parser;

    protected AbstractNode(NameParser parser, Map children, NodeFactory fac) throws ProcessingException {
        this._children = children;
        this._fac = fac;
        this._parser = parser;
        this._name = parser.parse("/").first();
        this._absolutePath.add(this._name);
    }

    protected AbstractNode(Map children, NodeFactory fac) throws ProcessingException {
        this(new DefaultNameParser(), children, fac);
    }

    public Node createChild(NamePart name) throws DuplicateException, ProcessingException {
        if (this._children.containsKey(name)) {
            throw new DuplicateException(name.asString());
        }
        Node n = this._fac.newNode();
        n.setUp(this, name);
        this._children.put(name, n);
        return n;
    }

    public Node getChild(NamePart name) {
        return (Node)this._children.get(name);
    }

    public Node removeChild(NamePart name) {
        return (Node)this._children.remove(name);
    }

    public Iterator getChildren() {
        return this._children.values().iterator();
    }

    public NamePart getName() {
        return this._name;
    }

    public Name getAbsolutePath() {
        return (Name)this._absolutePath.clone();
    }

    public int getChildrenCount() {
        return this._children.size();
    }

    public Iterator getChildrenNames() {
        return this._children.keySet().iterator();
    }

    public Node getParent() {
        return this._parent;
    }

    public NameParser getNameParser() {
        return this._parser;
    }

    public void setUp(Node parent, NamePart name) {
        this._parent = parent;
        this._absolutePath = new Name().add(parent.getAbsolutePath());
        this._name = name;
        this._absolutePath.add(name);
    }

    public String toString() {
        return this._name.toString();
    }

    public abstract /* synthetic */ Iterator getEntries();

    public abstract /* synthetic */ int getValueCount();

    public abstract /* synthetic */ Iterator getValueNames();

    public abstract /* synthetic */ boolean putValue(NamePart var1, Object var2, boolean var3);

    public abstract /* synthetic */ Object removeValue(NamePart var1);

    public abstract /* synthetic */ Object getValue(NamePart var1);
}

