/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie;

import org.sapia.archie.DuplicateException;
import org.sapia.archie.Name;
import org.sapia.archie.NameParser;
import org.sapia.archie.NamePart;
import org.sapia.archie.Node;
import org.sapia.archie.NotFoundException;
import org.sapia.archie.ProcessingException;
import org.sapia.archie.impl.DefaultNode;
import org.sapia.archie.strategy.DefaultLookupNodeStrategy;
import org.sapia.archie.strategy.DefaultLookupStrategy;

public class Archie {
    private Node _root;

    public Archie() throws ProcessingException {
        this._root = new DefaultNode();
    }

    public Archie(Node root) {
        this._root = root;
    }

    public Node getRoot() {
        return this._root;
    }

    public Object lookup(Name n) throws NotFoundException, ProcessingException {
        n = (Name)n.clone();
        DefaultLookupStrategy strat = new DefaultLookupStrategy();
        return strat.lookup(n, this._root);
    }

    public NameParser getNameParser() {
        return this._root.getNameParser();
    }

    public Node lookupNode(Name n, boolean create) throws NotFoundException, ProcessingException {
        n = (Name)n.clone();
        DefaultLookupNodeStrategy strat = new DefaultLookupNodeStrategy(create);
        return (Node)strat.lookup(n, this._root);
    }

    public void unbind(Name n) throws ProcessingException {
        if ((n = (Name)n.clone()).count() == 0) {
            return;
        }
        NamePart np = n.chopLast();
        try {
            this.lookupNode(n, false).removeValue(np);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void bind(Name n, Object o) throws DuplicateException, ProcessingException {
        this.doBind(n, o, false);
    }

    public void rebind(Name n, Object o) throws ProcessingException {
        this.doBind(n, o, true);
    }

    private void doBind(Name n, Object o, boolean overwrite) throws ProcessingException {
        n = (Name)n.clone();
        NamePart last = n.last();
        if (n.count() == 1 && last.asString().length() == 0) {
            throw new ProcessingException("Cannot bind object with empty name");
        }
        last = n.chopLast();
        DefaultLookupNodeStrategy strat = new DefaultLookupNodeStrategy(true);
        Node node = null;
        try {
            node = (Node)strat.lookup(n, this._root);
        }
        catch (NotFoundException e) {
            throw new ProcessingException(e.getMessage());
        }
        if (!node.putValue(last, o, overwrite)) {
            throw new DuplicateException(last.asString());
        }
    }
}

