/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sapia.archie.NamePart;

public class Name
implements Serializable {
    private List _parts = new ArrayList();
    private int _currentIndex;

    protected Name(List parts) {
        this._parts.addAll(parts);
    }

    public Name() {
    }

    public int count() {
        return this._parts.size();
    }

    public int getCurrentIndex() {
        return this._currentIndex;
    }

    public void setCurrentIndex(int i) {
        if (i < 0 || i > this._parts.size() - 1) {
            throw new IllegalArgumentException("Specified index exceeds bounds");
        }
        this._currentIndex = i;
    }

    public void reset() {
        this._currentIndex = 0;
    }

    public boolean hasNextPart() {
        boolean hasNext;
        boolean bl = hasNext = this._currentIndex < this._parts.size();
        if (!hasNext) {
            this.reset();
        }
        return hasNext;
    }

    public NamePart nextPart() {
        return (NamePart)this._parts.get(this._currentIndex++);
    }

    public NamePart get(int i) {
        return (NamePart)this._parts.get(i);
    }

    public Name add(NamePart part) {
        this._parts.add(part);
        return this;
    }

    public Name addAt(int pos, NamePart part) {
        this.assertPos(pos);
        this._parts.add(pos, part);
        return this;
    }

    public NamePart removeAt(int pos) {
        return (NamePart)this._parts.remove(pos);
    }

    public boolean endsWith(Name other) {
        if (this.count() < other.count()) {
            return false;
        }
        for (int i = other.count() - 1; i > 0; --i) {
            if (other.get(i).asString().equals(this.get(i).asString())) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(Name other) {
        if (this.count() < other.count()) {
            return false;
        }
        for (int i = 0; i < other.count(); ++i) {
            if (other.get(i).asString().equals(this.get(i).asString())) continue;
            return false;
        }
        return true;
    }

    public Name add(Name n) {
        this._parts.addAll(n._parts);
        return this;
    }

    public Name getTo(int to) {
        Name n = new Name();
        for (int i = 0; i < to; ++i) {
            NamePart current = (NamePart)this._parts.get(i);
            n._parts.add(current);
        }
        return n;
    }

    public Name getFrom(int from) {
        Name n = new Name();
        for (int i = from; i < this._parts.size(); ++i) {
            NamePart current = (NamePart)this._parts.get(i);
            n._parts.add(current);
        }
        return n;
    }

    public NamePart first() {
        return (NamePart)this._parts.get(0);
    }

    public NamePart last() {
        return (NamePart)this._parts.get(this._parts.size() - 1);
    }

    public NamePart chopLast() {
        return (NamePart)this._parts.remove(this._parts.size() - 1);
    }

    public NamePart chopFirst() {
        return (NamePart)this._parts.remove(0);
    }

    public Object clone() {
        return new Name(this._parts);
    }

    public String toString() {
        return this._parts.toString();
    }

    public boolean equals(Object o) {
        try {
            Name other = (Name)o;
            if (other.count() != this.count()) {
                return false;
            }
            for (int i = 0; i < other.count(); ++i) {
                if (other.get(i).asString().equals(this.get(i).asString())) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private void assertPos(int pos) {
        if (pos < 0) {
            throw new ArrayIndexOutOfBoundsException("Index too small: " + pos);
        }
        if (pos > this._parts.size()) {
            throw new ArrayIndexOutOfBoundsException("Index too large: " + pos);
        }
    }
}

