/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.impl;

import java.util.StringTokenizer;
import org.sapia.archie.Name;
import org.sapia.archie.NameParser;
import org.sapia.archie.NamePart;
import org.sapia.archie.ProcessingException;
import org.sapia.archie.impl.AttributeNamePart;

public class AttributeNameParser
implements NameParser {
    static final char QMARK = '?';
    static final String AMP = "&";
    static final char EQ = '=';
    static final String SLASH = "/";
    static final char SEPARATOR = '/';

    public String asString(Name name) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < name.count(); ++i) {
            buff.append(name.get(i).asString());
            if (i >= name.count() - 1) continue;
            buff.append('/');
        }
        return buff.toString();
    }

    public Name parse(String name) throws ProcessingException {
        Name n = new Name();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '/') {
                n.add(this.parseNamePart(buf.toString()));
                buf.delete(0, buf.length());
                continue;
            }
            buf.append(name.charAt(i));
        }
        if (buf.length() > 0) {
            n.add(this.parseNamePart(buf.toString()));
        }
        return n;
    }

    public NamePart parseNamePart(String namePart) throws ProcessingException {
        AttributeNamePart anp = new AttributeNamePart();
        this.parseName(anp, namePart);
        return anp;
    }

    private void parseName(AttributeNamePart anp, String name) {
        int idx = name.indexOf(63);
        if (idx < 0) {
            anp.setName(name);
            return;
        }
        anp.setName(name.substring(0, idx));
        if (idx == name.length() - 1) {
            return;
        }
        this.parseProperties(anp, name.substring(idx + 1));
    }

    private void parseProperties(AttributeNamePart anp, String props) {
        StringTokenizer st = new StringTokenizer(props, AMP);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.parseProperty(anp, token);
        }
    }

    private void parseProperty(AttributeNamePart anp, String prop) {
        String name = null;
        String value = null;
        int idx = prop.indexOf(61);
        if (idx < 0) {
            if (prop.length() > 0) {
                name = prop;
            }
        } else {
            name = prop.substring(0, idx);
            if (idx != prop.length() - 1) {
                value = prop.substring(idx + 1);
            }
        }
        if (name != null && value != null) {
            anp.addProperty(name, value);
        }
    }
}

