/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.sapia.archie.NamePart;
import org.sapia.archie.NodeFactory;
import org.sapia.archie.ProcessingException;
import org.sapia.archie.impl.AttributeNameParser;
import org.sapia.archie.impl.AttributeNamePart;
import org.sapia.archie.impl.MultiValueNode;
import org.sapia.archie.impl.Offer;
import org.sapia.archie.impl.SelectionHelper;

public class AttributeNode
extends MultiValueNode {
    protected AttributeNode(Map children, Map values, NodeFactory fac) throws ProcessingException {
        super(new AttributeNameParser(), children, values, fac);
    }

    public final Object getValue(NamePart name) {
        List values = (List)this._valueLists.get(name);
        if (values == null) {
            return null;
        }
        List matching = AttributeNode.selectMatchingOffers(name, values);
        if (matching.size() == 0) {
            return null;
        }
        Offer selected = (Offer)this.onSelect(matching);
        if (!this.isValid(selected)) {
            for (int i = 0; i < values.size(); ++i) {
                Offer other = (Offer)values.get(i);
                if (!other.getId().equals(selected.getId())) continue;
                values.remove(i);
                break;
            }
            return this.getValue(name);
        }
        Object toReturn = null;
        if (selected != null) {
            toReturn = this.onRead(name, selected.getObject());
            selected.select();
        }
        return toReturn;
    }

    public final boolean putValue(NamePart name, Object value, boolean overwrite) {
        ArrayList<Offer> values = (ArrayList<Offer>)this._valueLists.get(name);
        if (values == null) {
            values = new ArrayList<Offer>();
            this._valueLists.put(name, values);
        }
        if (!overwrite && values.size() != 0) {
            return false;
        }
        Object toBind = this.onWrite(name, value);
        if (toBind != null) {
            if (name instanceof AttributeNamePart) {
                values.add(new Offer(((AttributeNamePart)name).getAttributes(), toBind));
            } else {
                values.add(new Offer(new Properties(), toBind));
            }
        }
        return true;
    }

    public final Object removeValue(NamePart name) {
        Object val = this.getValue(name);
        List values = (List)this._valueLists.get(name);
        if (values == null) {
            return val;
        }
        List matching = AttributeNode.selectMatchingOffers(name, values);
        if (matching.size() == 0) {
            return val;
        }
        for (int i = 0; i < matching.size(); ++i) {
            this.removeOffer((Offer)matching.get(i), values);
        }
        if (values.size() == 0) {
            this._valueLists.remove(name);
        }
        return val;
    }

    protected final Object onSelect(List offers) {
        return this.onSelectOffer(offers);
    }

    protected Offer onSelectOffer(List offers) {
        return SelectionHelper.selectLeastUsed(offers);
    }

    protected boolean isValid(Offer offer) {
        return true;
    }

    private void removeOffer(Offer offer, List offers) {
        for (int i = 0; i < offers.size(); ++i) {
            if (!((Offer)offers.get(i)).getId().equals(offer.getId())) continue;
            offers.remove(i);
            --i;
        }
    }

    static List selectMatchingOffers(NamePart name, List offers) {
        ArrayList<Offer> matching = new ArrayList<Offer>();
        for (int i = 0; i < offers.size(); ++i) {
            Offer offer = (Offer)offers.get(i);
            if (name instanceof AttributeNamePart) {
                if (!offer.matches(((AttributeNamePart)name).getAttributes())) continue;
                matching.add(offer);
                continue;
            }
            matching.add(offer);
        }
        return matching;
    }
}

