/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sapia.archie.AbstractNode;
import org.sapia.archie.Entry;
import org.sapia.archie.NameParser;
import org.sapia.archie.NamePart;
import org.sapia.archie.NodeFactory;
import org.sapia.archie.ProcessingException;

public class MultiValueNode
extends AbstractNode {
    protected Map _valueLists;

    protected MultiValueNode(Map children, Map values, NodeFactory fac) throws ProcessingException {
        super(children, fac);
        this._valueLists = values;
    }

    protected MultiValueNode(NameParser parser, Map children, Map values, NodeFactory fac) throws ProcessingException {
        super(parser, children, fac);
        this._valueLists = values;
    }

    public Object getValue(NamePart name) {
        List values = (List)this._valueLists.get(name);
        if (values == null) {
            return null;
        }
        Object selected = this.onSelect(values);
        if (selected != null) {
            selected = this.onRead(name, selected);
        }
        return selected;
    }

    public Object removeValue(NamePart name) {
        Object val = this.getValue(name);
        this._valueLists.remove(name);
        return val;
    }

    public Iterator getEntries() {
        Iterator itr = this._valueLists.entrySet().iterator();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            List values = (List)entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                entries.add(new Entry(entry.getKey().toString(), values.get(i)));
            }
        }
        return entries.iterator();
    }

    public boolean putValue(NamePart name, Object value, boolean overwrite) {
        ArrayList<Object> values = (ArrayList<Object>)this._valueLists.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this._valueLists.put(name, values);
        }
        if (!overwrite && values.size() != 0) {
            return false;
        }
        Object toBind = this.onWrite(name, value);
        if (toBind != null) {
            values.add(toBind);
        }
        return true;
    }

    public Iterator getValueNames() {
        return this._valueLists.keySet().iterator();
    }

    public int getValueCount() {
        return this._valueLists.size();
    }

    public int getChildrenCount() {
        return this._valueLists.size();
    }

    public Iterator getChildrenNames() {
        return this._valueLists.keySet().iterator();
    }

    public Iterator getChildren() {
        return super.getChildren();
    }

    protected Object onSelect(List values) {
        if (values.size() > 0) {
            Object toReturn = values.remove(0);
            values.add(toReturn);
            return toReturn;
        }
        return null;
    }

    protected Object onRead(NamePart np, Object selected) {
        return selected;
    }

    protected Object onWrite(NamePart np, Object toBind) {
        return toBind;
    }

    static class ValueIterator
    implements Iterator {
        Iterator _lists;
        Iterator _current;

        ValueIterator(Iterator lists) {
            this._lists = lists;
        }

        public boolean hasNext() {
            if (this._current != null) {
                if (this._current.hasNext()) {
                    return true;
                }
                if (this._lists.hasNext()) {
                    this._current = ((List)this._lists.next()).iterator();
                    return this._current.hasNext();
                }
                return false;
            }
            if (this._lists.hasNext()) {
                this._current = ((List)this._lists.next()).iterator();
                return this.hasNext();
            }
            return false;
        }

        public Object next() {
            if (this._current == null && this.hasNext()) {
                return this._current.next();
            }
            return this._current.next();
        }

        public void remove() {
        }
    }
}

