/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.impl;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class Offer
implements Serializable {
    private Properties _attributes;
    private Object _obj;
    private String _uniqueId;
    private long _lastSelectTime = System.currentTimeMillis();
    private long _selectCount;
    private static long _counter = 0L;

    public Offer(Properties attributes, Object obj) {
        this._attributes = attributes;
        this._obj = obj;
        this._uniqueId = Offer.uniqueId();
    }

    public Properties getAttributes() {
        return this._attributes;
    }

    public String getId() {
        return this._uniqueId;
    }

    public long getLastSelectTime() {
        return this._lastSelectTime;
    }

    public long getSelectCount() {
        return this._selectCount;
    }

    Offer select() {
        this._lastSelectTime = System.currentTimeMillis();
        ++this._selectCount;
        return this;
    }

    public boolean matches(Properties props) {
        Iterator entries = ((Hashtable)props).entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String value = this._attributes.getProperty(entry.getKey().toString());
            if (value == null && entry.getValue() == null) continue;
            if (value == null && entry.getValue() != null) {
                return false;
            }
            if (value != null && entry.getValue() == null) {
                return false;
            }
            if (value != null && entry.getValue() != null && entry.getValue().toString().equals(value)) continue;
            return false;
        }
        return true;
    }

    public Object getObject() {
        return this._obj;
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer(super.toString());
        aBuffer.append("[id=").append(this._uniqueId).append(" object=").append(this._obj).append(" selectCount=").append(this._selectCount).append(" lastSelectTime=").append(this._lastSelectTime).append(" attributes=").append(this._attributes).append("]");
        return aBuffer.toString();
    }

    static synchronized String uniqueId() {
        return "" + _counter++;
    }
}

