/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.sapia.archie.AbstractNode;
import org.sapia.archie.Entry;
import org.sapia.archie.NameParser;
import org.sapia.archie.NamePart;
import org.sapia.archie.NodeFactory;
import org.sapia.archie.ProcessingException;

public class SingleValueNode
extends AbstractNode {
    protected Map _values;

    public SingleValueNode(Map children, Map values, NodeFactory fac) throws ProcessingException {
        super(children, fac);
        this._values = values;
    }

    public SingleValueNode(NameParser parser, Map children, Map values, NodeFactory fac) throws ProcessingException {
        super(parser, children, fac);
        this._values = values;
    }

    public Object getValue(NamePart name) {
        Object val = this._values.get(name);
        if (val != null) {
            return this.onRead(name, val);
        }
        return val;
    }

    public Object removeValue(NamePart name) {
        Object val = this.getValue(name);
        this._values.remove(name);
        return val;
    }

    public boolean putValue(NamePart name, Object value, boolean overwrite) {
        if (!overwrite && this._values.containsKey(name)) {
            return false;
        }
        value = this.onWrite(name, value);
        this._values.put(name, value);
        return true;
    }

    public int getValueCount() {
        return this._values.size();
    }

    public Iterator getValueNames() {
        return this._values.keySet().iterator();
    }

    public Iterator getEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>(this._values.size());
        Iterator items = this._values.entrySet().iterator();
        while (items.hasNext()) {
            Map.Entry entry = items.next();
            entries.add(new Entry(entry.getKey().toString(), entry.getValue()));
        }
        return entries.iterator();
    }

    protected Object onRead(NamePart np, Object toRead) {
        return toRead;
    }

    protected Object onWrite(NamePart np, Object o) {
        return o;
    }
}

