/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.jndi;

import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.sapia.archie.Archie;
import org.sapia.archie.DuplicateException;
import org.sapia.archie.Name;
import org.sapia.archie.Node;
import org.sapia.archie.NotFoundException;
import org.sapia.archie.ProcessingException;
import org.sapia.archie.jndi.JndiName;
import org.sapia.archie.jndi.JndiNameParser;
import org.sapia.archie.jndi.JndiNamingEnum;

public class JndiContext
implements Context {
    private Archie _archie;
    private Hashtable _env = new Hashtable();
    private NameParser _parser;

    public JndiContext(Node node) {
        this._archie = new Archie(node);
        this._parser = new JndiNameParser(node.getNameParser());
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this._env.put(propName, propVal);
    }

    public synchronized void bind(javax.naming.Name name, Object obj) throws NamingException {
        try {
            this._archie.bind(this.getNameFrom(name), obj);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not bind under '" + name + "'", e);
        }
    }

    public synchronized void bind(String name, Object obj) throws NamingException {
        try {
            this._archie.bind(this._archie.getNameParser().parse(name), obj);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not bind under '" + name + "'", e);
        }
    }

    public void close() throws NamingException {
    }

    public javax.naming.Name composeName(javax.naming.Name name, javax.naming.Name prefix) throws NamingException {
        Name toAdd = this.getNameFrom(name);
        Name prfx = this.getNameFrom(prefix);
        return new JndiName(prfx.add(toAdd));
    }

    public String composeName(String name, String prefix) throws NamingException {
        try {
            Name toAdd = this._archie.getNameParser().parse(name);
            Name prfx = this._archie.getNameParser().parse(prefix);
            return this._archie.getNameParser().asString(prfx.add(toAdd));
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not process name", e);
        }
    }

    public synchronized Context createSubcontext(javax.naming.Name name) throws NamingException {
        try {
            return this.newChildContext(this._archie.lookupNode(this.getNameFrom(name), true));
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not create subcontext", e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Could not create subcontext", e);
        }
    }

    public synchronized Context createSubcontext(String name) throws NamingException {
        try {
            return this.newChildContext(this._archie.lookupNode(this._archie.getNameParser().parse(name), true));
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not create subcontext", e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Could not create subcontext", e);
        }
    }

    public synchronized void destroySubcontext(javax.naming.Name name) throws NamingException {
        if (name.size() == 0) {
            return;
        }
        try {
            Name archName = this.getNameFrom(name);
            Node node = this._archie.lookupNode(archName, false);
            if (node.getParent() != null) {
                node.getParent().removeChild(archName.last());
            }
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not destroy subcontext", e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Context not found", e);
        }
    }

    public synchronized void destroySubcontext(String name) throws NamingException {
        try {
            Name archName = this._archie.getNameParser().parse(name);
            if (archName.count() == 0) {
                return;
            }
            Node node = this._archie.lookupNode(archName, false);
            if (node.getParent() != null) {
                node.getParent().removeChild(archName.last());
            }
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not destroy subcontext", e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Context not found", e);
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._env;
    }

    public synchronized String getNameInNamespace() throws NamingException {
        return this._archie.getNameParser().asString(this._archie.getRoot().getAbsolutePath());
    }

    public NameParser getNameParser(javax.naming.Name name) throws NamingException {
        return this._parser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this._parser;
    }

    public synchronized NamingEnumeration list(javax.naming.Name name) throws NamingException {
        try {
            Node node = this._archie.lookupNode(this.getNameFrom(name), false);
            return this.newNamingEnum(node.getEntries(), node.getChildren(), 2);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
    }

    public synchronized NamingEnumeration list(String name) throws NamingException {
        try {
            Node node = this._archie.lookupNode(this._archie.getNameParser().parse(name), false);
            return this.newNamingEnum(node.getEntries(), node.getChildren(), 2);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
    }

    public synchronized NamingEnumeration listBindings(javax.naming.Name name) throws NamingException {
        try {
            Node node = this._archie.lookupNode(this.getNameFrom(name), true);
            return this.newNamingEnum(node.getEntries(), node.getChildren(), 1);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
    }

    public synchronized NamingEnumeration listBindings(String name) throws NamingException {
        try {
            Node node = this._archie.lookupNode(this._archie.getNameParser().parse(name), true);
            return this.newNamingEnum(node.getEntries(), node.getChildren(), 1);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
    }

    public synchronized NamingEnumeration listObjects(javax.naming.Name name) throws NamingException {
        try {
            Node node = this._archie.lookupNode(this.getNameFrom(name), false);
            return this.newNamingEnum(node.getEntries(), node.getChildren(), 0);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
    }

    public synchronized NamingEnumeration listObjects(String name) throws NamingException {
        try {
            Node node = this._archie.lookupNode(this._archie.getNameParser().parse(name), false);
            return this.newNamingEnum(node.getEntries(), node.getChildren(), 0);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("Could not list objects under: " + name, e);
        }
    }

    public synchronized Object lookup(javax.naming.Name name) throws NamingException {
        if (name.size() == 0) {
            return this;
        }
        try {
            return this._archie.lookup(this.getNameFrom(name));
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not perform lookup", e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("No object found for: " + name, e);
        }
    }

    public synchronized Object lookup(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            return this;
        }
        try {
            return this._archie.lookup(this._archie.getNameParser().parse(name));
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not perform lookup", e);
        }
        catch (NotFoundException e) {
            throw this.getNamingException("No object found for: " + name, e);
        }
    }

    public synchronized Object lookupLink(javax.naming.Name name) throws NamingException {
        return this.lookup(name);
    }

    public synchronized Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public synchronized void rebind(javax.naming.Name name, Object obj) throws NamingException {
        try {
            this._archie.rebind(this.getNameFrom(name), obj);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not bind object for: " + name, e);
        }
    }

    public synchronized void rebind(String name, Object obj) throws NamingException {
        try {
            this._archie.rebind(this._archie.getNameParser().parse(name), obj);
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not bind object for: " + name, e);
        }
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._env.remove(propName);
    }

    public void rename(javax.naming.Name oldName, javax.naming.Name newName) throws NamingException {
        throw new NamingException("Rename not supported");
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new NamingException("Rename not supported");
    }

    public synchronized void unbind(javax.naming.Name name) throws NamingException {
        try {
            this._archie.unbind(this.getNameFrom(name));
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not unbind: " + name, e);
        }
    }

    public synchronized void unbind(String name) throws NamingException {
        try {
            this._archie.unbind(this._archie.getNameParser().parse(name));
        }
        catch (ProcessingException e) {
            throw this.getNamingException("Could not unbind: " + name, e);
        }
    }

    protected Name getNameFrom(javax.naming.Name name) throws NamingException {
        Name n = new Name();
        for (int i = 0; i < name.size(); ++i) {
            try {
                n.add(this._archie.getNameParser().parseNamePart(name.get(i)));
                continue;
            }
            catch (ProcessingException e) {
                throw this.getNamingException("Could not process name: " + name, e);
            }
        }
        return n;
    }

    protected Context newChildContext(Node node) {
        return new JndiContext(node);
    }

    protected NamingEnumeration newNamingEnum(Iterator entries, Iterator childNodes, int listType) {
        return new JndiNamingEnum(entries, childNodes, listType);
    }

    private NamingException getNamingException(String msg, ProcessingException e) {
        if (e instanceof DuplicateException) {
            NameAlreadyBoundException nabe = new NameAlreadyBoundException(msg);
            nabe.setRootCause(e);
            return nabe;
        }
        NamingException ne = new NamingException(msg);
        ne.setRootCause(e);
        return ne;
    }

    private NamingException getNamingException(String msg, NotFoundException e) {
        NameNotFoundException ne = new NameNotFoundException(msg);
        ne.setRootCause(e);
        ne.setResolvedName(new JndiName(e.getResolvedName()));
        ne.setRemainingName(new JndiName(e.getRemainingName()));
        return ne;
    }
}

