/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.jndi;

import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.sapia.archie.Entry;
import org.sapia.archie.Node;
import org.sapia.archie.jndi.JndiContext;

public class JndiNamingEnum
implements NamingEnumeration {
    public static final int LIST_OBJECTS = 0;
    public static final int LIST_BINDINGS = 1;
    public static final int LIST_NAMECLASS_PAIRS = 2;
    protected Iterator _entries;
    protected Iterator _childNodes;
    protected int _listType;

    public JndiNamingEnum(Iterator entries, Iterator childNodes, int listType) {
        this._entries = entries;
        this._childNodes = childNodes;
        this._listType = listType;
    }

    public void close() throws NamingException {
    }

    public boolean hasMore() throws NamingException {
        return this._entries.hasNext() || this._childNodes.hasNext();
    }

    public Object next() throws NamingException {
        if (this._listType == 1) {
            if (this._entries.hasNext()) {
                return this.toBinding((Entry)this._entries.next());
            }
            return this.toBinding((Node)this._childNodes.next());
        }
        if (this._listType == 2) {
            if (this._entries.hasNext()) {
                Entry entry = (Entry)this._entries.next();
                return new NameClassPair(entry.getName(), entry.getValue().getClass().getName(), true);
            }
            Node node = (Node)this._childNodes.next();
            Context ctx = this.newJndiContext(node);
            return new NameClassPair(node.getName().asString(), ctx.getClass().getName(), true);
        }
        if (this._entries.hasNext()) {
            return ((Entry)this._entries.next()).getValue();
        }
        return this.newJndiContext((Node)this._childNodes.next());
    }

    public boolean hasMoreElements() {
        return this._entries.hasNext() || this._childNodes.hasNext();
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new IllegalStateException(e.getClass() + " caught; message: " + e.getMessage());
        }
    }

    protected Binding toBinding(Entry entry) {
        return new Binding(entry.getName(), entry.getValue().getClass().getName(), entry.getValue(), true);
    }

    protected Binding toBinding(Node node) {
        Context ctx = this.newJndiContext(node);
        return new Binding(node.getName().asString(), ctx.getClass().getName(), ctx);
    }

    protected Context newJndiContext(Node node) {
        return new JndiContext(node);
    }
}

