/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.jndi.proxy;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ContextProxy
implements Context {
    protected Context _ctx;
    private NameParser _parser;
    private Name _absoluteName;

    public ContextProxy(Context ctx) throws NamingException {
        this._ctx = ctx;
        this._parser = ctx.getNameParser("");
        this._absoluteName = this._parser.parse(ctx.getNameInNamespace());
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this._ctx.addToEnvironment(propName, propVal);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this._ctx.bind(name, this.onBind(name, obj));
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(this._parser.parse(name), obj);
    }

    public void close() throws NamingException {
        this._ctx.close();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this._ctx.composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this._ctx.composeName(name, prefix);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.onSubContext(name, this._ctx.createSubcontext(name));
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this._parser.parse(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this._ctx.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this._ctx.destroySubcontext(name);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._ctx.getEnvironment();
    }

    public String getNameInNamespace() throws NamingException {
        return this._ctx.getNameInNamespace();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this._ctx.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this._ctx.getNameParser(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.onEnum(name, this._ctx.list(name));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this._parser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.onEnum(name, this._ctx.listBindings(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this._parser.parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        return this.onLookup(name, this._ctx.lookup(name));
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(this._parser.parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.onLookup(name, this._ctx.lookupLink(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this._ctx.lookupLink(this._parser.parse(name));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this._ctx.rebind(name, this.onRebind(name, obj));
    }

    public void rebind(String name, Object obj) throws NamingException {
        this._ctx.rebind(name, this.onRebind(this._parser.parse(name), obj));
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._ctx.removeFromEnvironment(propName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this._ctx.rename(oldName, newName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this._ctx.rename(oldName, newName);
    }

    public void unbind(Name name) throws NamingException {
        this._ctx.unbind(name);
    }

    public void unbind(String name) throws NamingException {
        this._ctx.unbind(name);
    }

    protected Object onBind(Name name, Object toBind) throws NamingException {
        return toBind;
    }

    protected Object onRebind(Name name, Object toBind) throws NamingException {
        return toBind;
    }

    protected Object onLookup(Name name, Object lookedUp) throws NamingException {
        return lookedUp;
    }

    protected Context onSubContext(Name ctxName, Context subContext) throws NamingException {
        return subContext;
    }

    protected NamingEnumeration onEnum(Name enumName, NamingEnumeration enumeration) throws NamingException {
        return enumeration;
    }

    protected Name getAbsoluteName() {
        return (Name)this._absoluteName.clone();
    }

    protected Context getInternalContext() {
        return this._ctx;
    }

    protected NameParser getNameParser() {
        return this._parser;
    }
}

