/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.archie.sync;

import java.util.Iterator;
import org.sapia.archie.DuplicateException;
import org.sapia.archie.Name;
import org.sapia.archie.NameParser;
import org.sapia.archie.NamePart;
import org.sapia.archie.Node;
import org.sapia.archie.ProcessingException;
import org.sapia.archie.sync.Synchronizer;
import org.sapia.archie.sync.SynchronizerAdapter;

public class SynchronizedNode
implements Node {
    private Node _node;
    private Synchronizer _sync = new SynchronizerAdapter();

    public SynchronizedNode(Node node) {
        this._node = node;
    }

    public void setSynchronizer(Synchronizer sync) {
        this._sync = sync;
    }

    public Synchronizer getSynchronizer() {
        return this._sync;
    }

    public void synchronizePut(NamePart valueName, Object toSync, boolean overwrite) {
        this._node.putValue(valueName, toSync, overwrite);
    }

    public void synchronizeRemove(NamePart valueName) {
        this._node.removeValue(valueName);
    }

    public Object synchronizeGet(NamePart valueName) {
        return this._node.getValue(valueName);
    }

    public Node createChild(NamePart name) throws DuplicateException, ProcessingException {
        return this._node.createChild(name);
    }

    public Name getAbsolutePath() {
        return this._node.getAbsolutePath();
    }

    public Node getChild(NamePart name) {
        return this._node.getChild(name);
    }

    public Iterator getChildren() {
        return this._node.getChildren();
    }

    public int getChildrenCount() {
        return this._node.getChildrenCount();
    }

    public Iterator getChildrenNames() {
        return this._node.getChildrenNames();
    }

    public Iterator getEntries() {
        return this._node.getEntries();
    }

    public NamePart getName() {
        return this._node.getName();
    }

    public NameParser getNameParser() {
        return this._node.getNameParser();
    }

    public Node getParent() {
        return this._node.getParent();
    }

    public Object getValue(NamePart name) {
        Object toReturn = this._node.getValue(name);
        if (toReturn == null) {
            toReturn = this._sync.onGetValue((Name)this.getAbsolutePath().clone(), name);
        }
        return toReturn;
    }

    public int getValueCount() {
        return this._node.getValueCount();
    }

    public Iterator getValueNames() {
        return this._node.getValueNames();
    }

    public boolean putValue(NamePart name, Object value, boolean overwrite) {
        boolean put = this._node.putValue(name, value, overwrite);
        this._sync.onPutValue((Name)this.getAbsolutePath().clone(), name, value, overwrite);
        return put;
    }

    public Node removeChild(NamePart name) {
        return this._node.removeChild(name);
    }

    public Object removeValue(NamePart name) {
        Object toReturn = this._node.removeValue(name);
        this._sync.onRemoveValue((Name)this.getAbsolutePath().clone(), name);
        return toReturn;
    }

    public void setUp(Node parent, NamePart nodeName) {
        this._node.setUp(parent, nodeName);
    }
}

