/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.clazzy;

import java.security.SecureClassLoader;

public class BaseClassLoader
extends SecureClassLoader {
    private boolean _parentFirst = true;

    public BaseClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    public BaseClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setParentFirst(boolean parentFirst) {
        this._parentFirst = parentFirst;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(name);
        if (clazz == null) {
            if (this._parentFirst && (clazz = this.loadClassFromParent(name)) != null) {
                if (resolve) {
                    super.resolveClass(clazz);
                }
                return clazz;
            }
            try {
                clazz = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (clazz == null && !this._parentFirst && (clazz = this.loadClassFromParent(name)) != null) {
                if (resolve) {
                    super.resolveClass(clazz);
                }
                return clazz;
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            super.resolveClass(clazz);
        }
        return clazz;
    }

    private Class loadClassFromParent(String name) {
        ClassLoader parent = this.getParent();
        if (parent != null) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

