/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.clazzy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.sapia.clazzy.BaseClassLoader;
import org.sapia.clazzy.Consts;
import org.sapia.clazzy.LoaderSelector;
import org.sapia.clazzy.URLEnabled;
import org.sapia.clazzy.Utils;
import org.sapia.clazzy.loader.FileSystemLoader;
import org.sapia.clazzy.loader.JarLoader;
import org.sapia.clazzy.loader.Loader;

public class CompositeClassLoader
extends BaseClassLoader
implements Consts {
    private List _loaders = Collections.synchronizedList(new ArrayList());
    private LoaderSelector _selector;
    private ResourceBundle _bundle;

    public CompositeClassLoader(ClassLoader parent, LoaderSelector selector) {
        super(parent);
        this._selector = selector;
    }

    public CompositeClassLoader(LoaderSelector selector) {
        this._selector = selector;
    }

    public URL[] getURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = (Loader)this._loaders.get(i);
            if (!(loader instanceof URLEnabled)) continue;
            try {
                urls.add(((URLEnabled)((Object)loader)).getURL());
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String name) throws ClassNotFoundException {
        Object clazz = null;
        byte[] classBytes = null;
        String resourceName = name.replace('.', '/') + ".class";
        List list = this._loaders;
        synchronized (list) {
            Loader loader;
            for (int i = 0; !(i >= this._loaders.size() || this._selector.acceptsClass(name, loader = (Loader)this._loaders.get(i)) && (classBytes = loader.loadBytes(resourceName)) != null); ++i) {
            }
        }
        if (classBytes == null) {
            throw new ClassNotFoundException(name);
        }
        String pckg = Utils.getPackageNameFor(name);
        if (pckg != null && this.getPackage(pckg) == null) {
            this.definePackage(pckg, "Clazzy Classloading API", "1.0", "Sapia OSS http://www.sapia-oss.org", "Clazzy Classloading API", "1.0", "Sapia OSS http://www.sapia-oss.org", null);
        }
        return super.defineClass(name, classBytes, 0, classBytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL findResource(String name) {
        URL toReturn = null;
        List list = this._loaders;
        synchronized (list) {
            Loader loader;
            for (int i = 0; !(i >= this._loaders.size() || this._selector.acceptsResource(name, loader = (Loader)this._loaders.get(i)) && (toReturn = loader.getURL(name)) != null); ++i) {
            }
        }
        return toReturn;
    }

    public void addLoader(Loader loader) {
        this._loaders.add(loader);
    }

    public void addPath(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.addLoader(new FileSystemLoader(file));
        } else {
            this.addLoader(new JarLoader(file));
        }
    }

    public void close() {
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = (Loader)this._loaders.get(i);
            try {
                loader.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

