/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.clazzy;

import java.io.File;
import java.util.StringTokenizer;
import org.sapia.clazzy.CompositeClassLoader;
import org.sapia.clazzy.LoaderSelector;
import org.sapia.clazzy.loader.FileSystemLoader;
import org.sapia.clazzy.loader.JarLoader;

public class CompositeClassLoaderBuilder {
    public static CompositeClassLoader parseClassPath(ClassLoader parent, LoaderSelector selector, String classpath) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, ":;");
        CompositeClassLoader loader = parent != null ? new CompositeClassLoader(parent, selector) : new CompositeClassLoader(Thread.currentThread().getContextClassLoader(), selector);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            File f = new File(path = path.replace('\\', File.separatorChar));
            if (f.isDirectory()) {
                loader.addLoader(new FileSystemLoader(f));
                continue;
            }
            loader.addLoader(new JarLoader(f));
        }
        return loader;
    }
}

