/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.clazzy;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.sapia.clazzy.BaseClassLoader;
import org.sapia.clazzy.Consts;
import org.sapia.clazzy.Utils;
import org.sapia.clazzy.loader.FileSystemLoader;

public class FileSystemClassLoader
extends BaseClassLoader
implements Consts {
    private FileSystemLoader _loader;

    public FileSystemClassLoader(File baseDir) {
        this._loader = new FileSystemLoader(baseDir);
    }

    public FileSystemClassLoader(ClassLoader parent, File baseDir) {
        super(parent);
        this._loader = new FileSystemLoader(baseDir);
    }

    public File getFile() {
        return this._loader.getBaseDir();
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (!this._loader.getBaseDir().exists() || !this._loader.getBaseDir().isDirectory()) {
            throw new ClassNotFoundException(name);
        }
        String className = name.replace('.', File.separatorChar) + ".class";
        byte[] classBytes = this._loader.loadBytes(className);
        if (classBytes == null) {
            throw new ClassNotFoundException(name);
        }
        String pckg = Utils.getPackageNameFor(name);
        if (pckg != null && this.getPackage(pckg) == null) {
            this.definePackage(pckg, "Clazzy Classloading API", "1.0", "Sapia OSS http://www.sapia-oss.org", "Clazzy Classloading API", "1.0", "Sapia OSS http://www.sapia-oss.org", null);
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    protected URL findResource(String name) {
        if (!this._loader.getBaseDir().exists() || !this._loader.getBaseDir().isDirectory()) {
            return null;
        }
        try {
            File f = new File(this._loader.getBaseDir(), name);
            if (f.exists() && f.isFile()) {
                return f.toURL();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

