/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.clazzy;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import org.sapia.clazzy.BaseClassLoader;
import org.sapia.clazzy.Consts;
import org.sapia.clazzy.Utils;
import org.sapia.clazzy.loader.JarLoader;

public class JarClassLoader
extends BaseClassLoader
implements Consts {
    private JarLoader _jar;
    ResourceBundle bundle;

    public JarClassLoader(File jar) {
        this._jar = new JarLoader(jar);
    }

    public JarClassLoader(ClassLoader parent, File jar) {
        super(parent);
        this._jar = new JarLoader(jar);
    }

    public File getFile() {
        return this._jar.getJarFile();
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (!this._jar.getJarFile().exists()) {
            throw new ClassNotFoundException(name);
        }
        String resourceName = name.replace('.', '/') + ".class";
        byte[] classBytes = this._jar.loadBytes(resourceName);
        if (classBytes == null) {
            throw new ClassNotFoundException(name);
        }
        String pckg = Utils.getPackageNameFor(name);
        if (pckg != null && this.getPackage(pckg) == null) {
            this.definePackage(pckg, "Clazzy Classloading API", "1.0", "Sapia OSS http://www.sapia-oss.org", "Clazzy Classloading API", "1.0", "Sapia OSS http://www.sapia-oss.org", null);
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    public InputStream findResourceAsStream(String name) {
        if (!this._jar.getJarFile().exists()) {
            return null;
        }
        byte[] toReturn = this._jar.loadBytes(name);
        if (toReturn == null) {
            return null;
        }
        return new ByteArrayInputStream(toReturn);
    }

    protected URL findResource(String name) {
        try {
            return new URL("clazzy", "", this._jar.getJarFile().getAbsolutePath() + "?" + name);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void close() {
        this._jar.close();
    }
}

