/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.clazzy.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.sapia.clazzy.URLEnabled;
import org.sapia.clazzy.Utils;
import org.sapia.clazzy.loader.Loader;

public class FileSystemLoader
implements Loader,
URLEnabled {
    private File _baseDir;

    public FileSystemLoader(File baseDir) {
        this._baseDir = baseDir;
    }

    public File getBaseDir() {
        return this._baseDir;
    }

    public URL getURL() throws MalformedURLException {
        return this._baseDir.toURL();
    }

    public URL getURL(String resourceName) {
        try {
            File toReturn = new File(this._baseDir, resourceName);
            if (toReturn.exists() && toReturn.isFile()) {
                return toReturn.toURL();
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadBytes(String resourceName) {
        File toLoad = new File(this._baseDir, resourceName);
        if (!toLoad.exists()) {
            return null;
        }
        FileInputStream byteStream = null;
        try {
            byteStream = new FileInputStream(toLoad);
            byte[] byArray = Utils.streamToBytes(byteStream);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (byteStream != null) {
                try {
                    ((InputStream)byteStream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void close() {
    }
}

