/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.clazzy.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.sapia.clazzy.URLEnabled;
import org.sapia.clazzy.Utils;
import org.sapia.clazzy.loader.Loader;

public class JarLoader
implements Loader,
URLEnabled {
    private File _jar;
    private JarFile _file;

    public JarLoader(File jar) {
        this._jar = jar;
        try {
            this._file = new JarFile(jar);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getJarFile() {
        return this._jar;
    }

    public URL getURL() throws MalformedURLException {
        return this._jar.toURL();
    }

    public URL getURL(String resourceName) {
        if (this._file == null) {
            return null;
        }
        ZipEntry entry = this._file.getEntry(resourceName);
        if (entry == null) {
            return null;
        }
        try {
            return new URL("clazzy", "", this._jar.getAbsolutePath() + "?" + resourceName);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadBytes(String resourceName) {
        byte[] byArray;
        if (this._file == null) {
            return null;
        }
        InputStream entryStream = null;
        try {
            ZipEntry entry = this._file.getEntry(resourceName);
            if (entry == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            entryStream = this._file.getInputStream(entry);
            byArray = Utils.streamToBytes(entryStream);
        }
        catch (IOException e) {
            byte[] byArray3 = null;
            return byArray3;
        }
        finally {
            if (entryStream != null) {
                try {
                    entryStream.close();
                }
                catch (IOException e) {}
            }
        }
        return byArray;
    }

    public void close() {
        if (this._file != null) {
            try {
                this._file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

