package org.sapia.ubik.rmi.naming.remote.archie;

import org.sapia.archie.Node;
import org.sapia.archie.NodeFactory;
import org.sapia.archie.ProcessingException;
import org.sapia.archie.sync.Synchronizer;


/**
 * @author Yanick Duchesne
 * <dl>
 * <dt><b>Copyright:</b><dd>Copyright &#169; 2002-2003 <a href="http://www.sapia-oss.org">Sapia Open Source Software</a>. All Rights Reserved.</dd></dt>
 * <dt><b>License:</b><dd>Read the license.txt file of the jar or visit the
 *        <a href="http://www.sapia-oss.org/license.html">license page</a> at the Sapia OSS web site</dd></dt>
 * </dl>
 */
public class UbikNodeFactory implements NodeFactory {
  private Synchronizer _sync;

  UbikNodeFactory(Synchronizer sync) {
    _sync = sync;
  }

  /**
   * @see org.sapia.archie.NodeFactory#newNode()
   */
  public Node newNode() throws ProcessingException {
    UbikSyncNode node = new UbikSyncNode(this);
    node.setSynchronizer(_sync);

    return node;
  }
}
