/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.ioc.guice;

import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.sapia.ubik.ioc.guice.NamingService;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.rmi.naming.remote.RemoteInitialContextFactory;
import org.sapia.ubik.rmi.naming.remote.discovery.DiscoveryHelper;
import org.sapia.ubik.rmi.naming.remote.discovery.JndiDiscoListener;
import org.sapia.ubik.rmi.naming.remote.discovery.ServiceDiscoListener;
import org.sapia.ubik.rmi.naming.remote.proxy.ReliableLocalContext;
import org.sapia.ubik.rmi.server.Log;

@Singleton
public class NamingServiceImpl
implements NamingService,
JndiDiscoListener {
    private String _domain;
    private String _host;
    private String _addr;
    private int _port;
    private int _mcastPort;
    private Context _ctx;
    private Set<Object> _toBind = Collections.synchronizedSet(new HashSet());
    private DiscoveryHelper _helper;

    public NamingServiceImpl(String domain) throws IOException {
        this._domain = domain;
        this.init();
    }

    public NamingServiceImpl setJndiHost(String host) {
        this._host = host;
        return this;
    }

    public NamingServiceImpl setJndiPort(int port) {
        this._port = port;
        return this;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public void setMulticastAddress(String addr) {
        this._addr = addr;
    }

    public void setMulticastPort(int port) {
        this._mcastPort = port;
    }

    public EventChannel getEventChannel() {
        return this._helper.getChannel();
    }

    @Override
    public synchronized void bind(String name, Object o) throws NamingException {
        if (this._ctx == null) {
            this._toBind.add(new Binding(name, o));
            return;
        }
        if (Log.isInfo()) {
            Log.info(this.getClass(), (Object)("Binding: " + name + ", " + o + " - to context: " + this._ctx));
        }
        this._ctx.bind(name, o);
    }

    @Override
    public synchronized Object lookup(String name) throws NamingException, NameNotFoundException {
        if (this._ctx == null) {
            throw new NamingException("No connection to JNDI");
        }
        return this._ctx.lookup(name);
    }

    @Override
    public void register(ServiceDiscoListener listener) {
        if (this._helper != null) {
            this._helper.addServiceDiscoListener(listener);
        }
    }

    @Override
    public void unregister(ServiceDiscoListener listener) {
        if (this._helper != null) {
            this._helper.removeServiceDiscoListener(listener);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this._ctx != null) {
                this._ctx.close();
            }
            if (this._helper != null) {
                this._helper.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void init() throws IOException {
        if (this._port == 0) {
            this._port = 1099;
        }
        if (this._host == null) {
            this._host = "localhost";
        }
        if (this._mcastPort == 0) {
            this._mcastPort = 5454;
        }
        if (this._addr == null) {
            this._addr = "231.173.5.7";
        }
        try {
            this._ctx = this.getInitialContext(this._domain, this._host, this._port);
            Log.info(this.getClass(), (Object)"Got JNDI initial context");
            EventChannel channel = ReliableLocalContext.currentContext().getEventChannel();
            if (channel != null) {
                this._helper = this.getDiscoHelper(channel);
                Log.info(this.getClass(), (Object)"Got discovery helper");
            }
        }
        catch (NamingException e) {
            Log.info(this.getClass(), (Object)("Could not get JNDI initial context for (domain:host:port):" + this._domain + ":" + this._host + ":" + this._port));
            this._helper = this.getDiscoHelper(this._domain, this._addr, this._mcastPort);
            this._helper.addJndiDiscoListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onJndiDiscovered(Context context) {
        Log.info(this.getClass(), (Object)"Discovered JNDI");
        this._ctx = context;
        this._helper.removeJndiDiscoListener(this);
        NamingServiceImpl namingServiceImpl = this;
        synchronized (namingServiceImpl) {
            Iterator<Object> entries = this._toBind.iterator();
            while (entries.hasNext()) {
                Binding entry = (Binding)entries.next();
                if (entry.getObject() == null) continue;
                try {
                    this._ctx.bind(entry.getName(), entry.getObject());
                    entries.remove();
                }
                catch (NamingException e) {}
            }
        }
    }

    protected DiscoveryHelper getDiscoHelper(String domain, String mcastHost, int mcastPort) throws IOException {
        return new DiscoveryHelper(domain, mcastHost, mcastPort);
    }

    protected DiscoveryHelper getDiscoHelper(EventChannel channel) throws IOException {
        return new DiscoveryHelper(channel);
    }

    protected InitialContext getInitialContext(String domain, String host, int port) throws NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
        props.setProperty("ubik.jndi.domain", this._domain);
        props.setProperty("java.naming.provider.url", "ubik://" + this._host + ":" + this._port);
        return new InitialContext(props);
    }

    static class Binding {
        SoftReference<Object> _object;
        String _name;

        Binding(String name, Object o) {
            this._name = name;
            this._object = new SoftReference<Object>(o);
        }

        Object getObject() {
            return this._object.get();
        }

        String getName() {
            return this._name;
        }
    }
}

