/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.ioc.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import org.sapia.ubik.ioc.guice.NamingService;
import org.sapia.ubik.rmi.naming.remote.discovery.ServiceDiscoListener;
import org.sapia.ubik.rmi.naming.remote.discovery.ServiceDiscoveryEvent;
import org.sapia.ubik.rmi.server.Log;

public class RemoteServiceImporter<T>
implements Provider<T> {
    @Inject
    private NamingService _naming;
    private String _name;
    private T _remote;
    private Class<T> _type;

    public RemoteServiceImporter(Class<T> type, String jndiName) {
        this._type = type;
        this._name = jndiName;
    }

    public T get() {
        if (this._name == null) {
            throw new IllegalStateException("JNDI name not set on this provider");
        }
        if (this._naming == null) {
            throw new IllegalStateException(NamingService.class.getName() + " instance not set on this provider");
        }
        try {
            this._remote = this._type.cast(this._naming.lookup(this._name));
            if (Log.isInfo()) {
                Log.info(this.getClass(), (Object)("Resolved remote service: " + this._name));
            }
            return this._remote;
        }
        catch (Exception e) {
            Log.warning(this.getClass(), (Object)("Could not resolve remote service: " + this._name + "; attempting discovery"));
            Log.error(this.getClass(), (Object)e);
            this._naming.register(new ServiceDiscoListenerImpl());
            return this._type.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this._type}, (InvocationHandler)new ProxyInvocationHandler(this)));
        }
    }

    public class ProxyInvocationHandler
    implements InvocationHandler {
        private RemoteServiceImporter<T> _owner;

        ProxyInvocationHandler(RemoteServiceImporter<T> owner) {
            this._owner = owner;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this._owner._remote != null) {
                try {
                    Object result = method.invoke(this._owner._remote, args);
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new NoSuchObjectException(this._owner._name);
            }
        }
    }

    class ServiceDiscoListenerImpl
    implements ServiceDiscoListener {
        ServiceDiscoListenerImpl() {
        }

        @Override
        public void onServiceDiscovered(ServiceDiscoveryEvent anEvent) {
            if (anEvent.getName().equals(RemoteServiceImporter.this._name) || anEvent.getName().charAt(0) == '/' && anEvent.getName().substring(1).equals(RemoteServiceImporter.this._name)) {
                try {
                    RemoteServiceImporter.this._remote = RemoteServiceImporter.this._type.cast(anEvent.getService());
                    RemoteServiceImporter.this._naming.unregister(this);
                }
                catch (Exception e) {
                    Log.error(this.getClass(), (Object)("Could not resolve remote service: " + RemoteServiceImporter.this._name), (Throwable)e);
                }
            }
        }
    }
}

