/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.ioc.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import org.sapia.ubik.ioc.NamingService;
import org.sapia.ubik.ioc.spring.NamingServiceBean;
import org.sapia.ubik.ioc.spring.RemoteBeanRef;
import org.sapia.ubik.rmi.naming.remote.discovery.ServiceDiscoListener;
import org.sapia.ubik.rmi.naming.remote.discovery.ServiceDiscoveryEvent;
import org.sapia.ubik.rmi.server.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class BeanImporterPostProcessor
implements BeanPostProcessor {
    private NamingService _naming;

    public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        if (bean instanceof NamingService) {
            this._naming = (NamingService)bean;
        } else if (bean instanceof RemoteBeanRef) {
            RemoteBeanRef ref = (RemoteBeanRef)bean;
            if (ref.getName() == null) {
                throw new FatalBeanException("'name' property not set on remote bean reference");
            }
            if (this._naming == null) {
                throw new IllegalStateException(NamingService.class.getName() + " not passed to this post processor; make sure you declare a " + NamingServiceBean.class.getName());
            }
            Object remote = null;
            try {
                remote = this._naming.lookup(ref.getName());
                if (Log.isInfo()) {
                    Log.info(this.getClass(), (Object)("Resolved remote service: " + ref.getName()));
                }
                return remote;
            }
            catch (Exception e) {
                Log.warning(this.getClass(), (Object)("Could not resolve remote service: " + ref.getName() + "; attempting discovery"));
                Log.error(this.getClass(), (Object)e);
                ProxyInvocationHandler handler = new ProxyInvocationHandler(ref.getName());
                this._naming.register(new ServiceDiscoListenerImpl(handler));
                if (ref.getInterfaces() == null) {
                    throw new FatalBeanException("'interfaces' property not set on remote bean reference: " + ref.getName());
                }
                return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), ref.getInterfaces(), (InvocationHandler)handler);
            }
        }
        return null;
    }

    public Object postProcessBeforeInitialization(Object bean, String arg1) throws BeansException {
        return bean;
    }

    public class ProxyInvocationHandler
    implements InvocationHandler {
        Object _remote;
        String _name;

        ProxyInvocationHandler(String name) {
            this._name = name;
        }

        public void setRemoteObject(Object remote) {
            this._remote = remote;
        }

        public String getName() {
            return this._name;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this._remote != null) {
                try {
                    Object result = method.invoke(this._remote, args);
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new NoSuchObjectException(this._name);
            }
        }
    }

    class ServiceDiscoListenerImpl
    implements ServiceDiscoListener {
        private ProxyInvocationHandler _handler;

        public ServiceDiscoListenerImpl(ProxyInvocationHandler handler) {
            this._handler = handler;
        }

        @Override
        public void onServiceDiscovered(ServiceDiscoveryEvent anEvent) {
            if (anEvent.getName().equals(this._handler.getName()) || anEvent.getName().charAt(0) == '/' && anEvent.getName().substring(1).equals(this._handler.getName())) {
                try {
                    this._handler.setRemoteObject(anEvent.getService());
                    BeanImporterPostProcessor.this._naming.unregister(this);
                }
                catch (Exception e) {
                    Log.error(this.getClass(), (Object)("Could not resolve remote service: " + this._handler.getName()), (Throwable)e);
                }
            }
        }
    }
}

