/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.mcast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.BroadcastDispatcher;
import org.sapia.ubik.mcast.EventConsumer;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.mcast.Util;
import org.sapia.ubik.mcast.server.MulticastServer;
import org.sapia.ubik.rmi.server.Log;

public class BroadcastDispatcherImpl
implements BroadcastDispatcher {
    static final int DEFAULT_BUFSZ = 5000;
    static final int TTL = 7;
    private boolean _started;
    private String _node;
    private String _domain;
    private BroadcastServer _server;
    private EventConsumer _consumer;
    private int _bufsz = 5000;

    public BroadcastDispatcherImpl(EventConsumer cons, String mcastHost, int mcastPort) throws IOException {
        this._server = new BroadcastServer(cons, 15, mcastHost, mcastPort, 7);
        this._server.setBufsize(this._bufsz);
        this._consumer = cons;
        this._node = cons.getNode();
        this._domain = cons.getDomainName().toString();
    }

    public BroadcastDispatcherImpl(String node, String domain, String mcastHost, int mcastPort, int ttl) throws IOException {
        this(new EventConsumer(node, domain), mcastHost, mcastPort);
    }

    public BroadcastDispatcherImpl(String domain, String mcastHost, int mcastPort) throws IOException {
        this(new EventConsumer(domain), mcastHost, mcastPort);
    }

    @Override
    public void setBufsize(int size) {
        this._bufsz = size;
        this._server.setBufsize(size);
    }

    @Override
    public String getNode() {
        return this._node;
    }

    @Override
    public synchronized void close() {
        if (this._server != null) {
            this._server.close();
            this._server = null;
        }
    }

    @Override
    public void dispatch(boolean alldomains, String evtType, Object data) throws IOException {
        RemoteEvent evt = alldomains ? new RemoteEvent(null, evtType, data).setNode(this._node) : new RemoteEvent(this._domain, evtType, data).setNode(this._node);
        this._server.send(Util.toBytes(evt, this._bufsz));
    }

    @Override
    public void dispatch(String domain, String evtType, Object data) throws IOException {
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("Sending event bytes for: " + evtType));
        }
        RemoteEvent evt = new RemoteEvent(domain, evtType, data).setNode(this._node);
        this._server.send(Util.toBytes(evt, this._bufsz));
    }

    public synchronized void registerAsyncListener(String evtType, AsyncEventListener listener) {
        this._consumer.registerAsyncListener(evtType, listener);
    }

    public synchronized void unregisterListener(AsyncEventListener listener) {
        this._consumer.unregisterListener(listener);
    }

    @Override
    public void start() {
        this._server.setDaemon(true);
        this._server.start();
    }

    @Override
    public String getMulticastAddress() {
        return this._server.getMulticastAddress();
    }

    @Override
    public int getMulticastPort() {
        return this._server.getMulticastPort();
    }

    static class BroadcastServer
    extends MulticastServer {
        EventConsumer _consumer;

        public BroadcastServer(EventConsumer consumer, int soTimeout, String mcastAddress, int mcastPort, int ttl) throws IOException {
            super("ubik.mcast.BroadcastServer", soTimeout, mcastAddress, mcastPort, ttl);
            this._consumer = consumer;
        }

        @Override
        protected void handle(DatagramPacket pack, MulticastSocket sock) {
            try {
                this._consumer.onAsyncEvent((RemoteEvent)Util.fromDatagram(pack));
            }
            catch (Exception e) {
                Log.error(this.getClass(), (Object)"Could not deserialize remote event", (Throwable)e);
            }
        }

        @Override
        protected void handlePacketSizeToShort(DatagramPacket pack) {
            System.err.println("Packet size to short: " + pack.getLength() + " - increase buffer size to correct.");
        }

        @Override
        protected void handleSoTimeout() {
        }
    }
}

