/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.mcast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.BroadcastDispatcher;
import org.sapia.ubik.mcast.BroadcastDispatcherImpl;
import org.sapia.ubik.mcast.DiscoveryListener;
import org.sapia.ubik.mcast.DomainName;
import org.sapia.ubik.mcast.EventConsumer;
import org.sapia.ubik.mcast.ListenerAlreadyRegisteredException;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.mcast.RespList;
import org.sapia.ubik.mcast.Response;
import org.sapia.ubik.mcast.SocketTimeoutListener;
import org.sapia.ubik.mcast.SyncEventListener;
import org.sapia.ubik.mcast.TimeoutException;
import org.sapia.ubik.mcast.UDPUnicastDispatcher;
import org.sapia.ubik.mcast.UnicastDispatcher;
import org.sapia.ubik.mcast.View;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.Log;

public class EventChannel {
    static final String DISCOVER_EVT = "ubik/mcast/discover";
    static final String PUBLISH_EVT = "ubik/mcast/publish";
    static final String HEARTBEAT_EVT = "ubik/mcast/heartbeat";
    BroadcastDispatcher _broadcast;
    UnicastDispatcher _unicast;
    EventConsumer _consumer;
    ChannelEventListener _listener;
    View _view = new View(30000L);
    ServerAddress _address;
    List _discoListeners = new ArrayList();
    boolean _started;
    boolean _closed;

    public EventChannel(String domain, String mcastHost, int mcastPort) throws IOException {
        this._consumer = new EventConsumer(domain);
        this._broadcast = new BroadcastDispatcherImpl(this._consumer, mcastHost, mcastPort);
        this._unicast = new UDPUnicastDispatcher(10000, this._consumer);
        this.init();
    }

    public EventChannel(String domain, String mcastHost, int mcastPort, int unicastPort) throws IOException {
        this._consumer = new EventConsumer(domain);
        String soTimeoutProp = System.getProperty("ubik.rmi.naming.mcast.heartbeat.interval");
        int soTimeout = 20000;
        if (soTimeoutProp != null) {
            try {
                soTimeout = Integer.parseInt(soTimeoutProp);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this._unicast = new UDPUnicastDispatcher(soTimeout, unicastPort, this._consumer);
        this._broadcast = new BroadcastDispatcherImpl(this._consumer, mcastHost, mcastPort);
        this.init();
    }

    public DomainName getDomainName() {
        return this._consumer.getDomainName();
    }

    public String getMulticastHost() {
        return this._broadcast.getMulticastAddress();
    }

    public int getMulticastPort() {
        return this._broadcast.getMulticastPort();
    }

    public void start() throws IOException {
        this._listener = new ChannelEventListener(this);
        this._consumer.registerAsyncListener(PUBLISH_EVT, this._listener);
        this._consumer.registerAsyncListener(DISCOVER_EVT, this._listener);
        this._consumer.registerAsyncListener(HEARTBEAT_EVT, this._listener);
        this._unicast.setSoTimeoutListener(this._listener);
        this._unicast.setBufsize(2000);
        this._broadcast.start();
        this._unicast.start();
        this._address = this._unicast.getAddress();
        this._broadcast.dispatch(false, PUBLISH_EVT, (Object)this._address);
        this._started = true;
    }

    public boolean isStarted() {
        return this._started;
    }

    public void close() {
        this._broadcast.close();
        this._unicast.close();
        this._closed = true;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void dispatch(boolean alldomains, String type, Object data) throws IOException {
        this._broadcast.dispatch(alldomains, type, data);
    }

    public void dispatch(ServerAddress addr, String type, Object data) throws IOException {
        this._unicast.dispatch(addr, type, data);
    }

    public void dispatch(String type, Object data) throws IOException {
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("Sending event " + type + " - " + data));
        }
        this._broadcast.dispatch(this._consumer.getDomainName().toString(), type, data);
    }

    public void addDiscoveryListener(DiscoveryListener listener) {
        this._discoListeners.add(listener);
    }

    public Response send(ServerAddress addr, String type, Object data) throws IOException, TimeoutException {
        return this._unicast.send(addr, type, data);
    }

    public RespList send(String type, Object data) throws IOException {
        return this._unicast.send(this._view.getHosts(), type, data);
    }

    public synchronized void registerAsyncListener(String type, AsyncEventListener listener) {
        this._consumer.registerAsyncListener(type, listener);
    }

    public synchronized void registerSyncListener(String type, SyncEventListener listener) throws ListenerAlreadyRegisteredException {
        this._consumer.registerSyncListener(type, listener);
    }

    public synchronized void unregisterListener(AsyncEventListener listener) {
        this._consumer.unregisterListener(listener);
    }

    public View getView() {
        return this._view;
    }

    public synchronized boolean containsAsyncListener(AsyncEventListener listener) {
        return this._consumer.containsAsyncListener(listener);
    }

    public synchronized boolean containsSyncListener(SyncEventListener listener) {
        return this._consumer.containsSyncListener(listener);
    }

    public void setBufsize(int size) {
        this._broadcast.setBufsize(size);
        this._unicast.setBufsize(size);
    }

    public String getNode() {
        return this._broadcast.getNode();
    }

    private void init() {
        String heartBeatTimeout;
        String bufsizeStr = System.getProperty("ubik.rmi.naming.mcast.bufsize");
        if (bufsizeStr != null) {
            try {
                int buf = Integer.parseInt(bufsizeStr);
                if (buf > 0) {
                    this._broadcast.setBufsize(buf);
                    this._unicast.setBufsize(buf);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((heartBeatTimeout = System.getProperty("ubik.rmi.naming.mcast.heartbeat.timeout")) != null) {
            try {
                this._view.setTimeout(Long.parseLong(heartBeatTimeout));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static class ChannelEventListener
    implements AsyncEventListener,
    SocketTimeoutListener {
        private EventChannel _owner;

        ChannelEventListener(EventChannel channel) {
            this._owner = channel;
        }

        @Override
        public void handleSoTimeout() {
            this._owner._view.removeDeadHosts();
            List siblings = this._owner._view.getHosts();
            if (this._owner._address != null) {
                for (int i = 0; i < siblings.size(); ++i) {
                    try {
                        this._owner.dispatch((ServerAddress)siblings.get(i), EventChannel.HEARTBEAT_EVT, (Object)this._owner._address);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        }

        @Override
        public void onAsyncEvent(RemoteEvent evt) {
            if (evt.getType().equals(EventChannel.DISCOVER_EVT)) {
                try {
                    ServerAddress addr = (ServerAddress)evt.getData();
                    if (addr == null) {
                        return;
                    }
                    this._owner._view.addHost(addr, evt.getNode());
                    List listeners = this._owner._discoListeners;
                    for (int i = 0; i < listeners.size(); ++i) {
                        ((DiscoveryListener)listeners.get(i)).onDiscovery(addr, evt);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (evt.getType().equals(EventChannel.PUBLISH_EVT)) {
                try {
                    ServerAddress addr = (ServerAddress)evt.getData();
                    if (addr == null) {
                        return;
                    }
                    this._owner._view.addHost(addr, evt.getNode());
                    this._owner.dispatch(false, EventChannel.DISCOVER_EVT, (Object)this._owner._address);
                    List listeners = this._owner._discoListeners;
                    for (int i = 0; i < listeners.size(); ++i) {
                        ((DiscoveryListener)listeners.get(i)).onDiscovery(addr, evt);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (evt.getType().equals(EventChannel.HEARTBEAT_EVT)) {
                try {
                    ServerAddress addr = (ServerAddress)evt.getData();
                    this._owner._view.heartbeat(addr, evt.getNode());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

