/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.mcast;

import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.DomainName;
import org.sapia.ubik.mcast.ListenerAlreadyRegisteredException;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.mcast.SyncEventListener;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.UIDGenerator;

public class EventConsumer {
    private static int _count;
    private static Random _rand;
    private Map _asyncListenersByEvent = new HashMap();
    private Map _syncListenersByEvent = new HashMap();
    private Map _reverseMap = new WeakHashMap();
    private DomainName _domain;
    private String _node;

    public EventConsumer(String node, String domain) {
        this._domain = DomainName.parse(domain);
        this._node = node;
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("Starting node: " + node + "@" + domain));
        }
    }

    public EventConsumer(String domain) throws UnknownHostException {
        this(new String("" + ((long)(InetAddress.getLocalHost().getHostAddress().hashCode() ^ new Object().hashCode()) ^ UIDGenerator.createdUID())) + "_" + _rand.nextLong(), domain);
    }

    public String getNode() {
        return this._node;
    }

    public DomainName getDomainName() {
        return this._domain;
    }

    public synchronized void registerAsyncListener(String evtType, AsyncEventListener listener) {
        List lst = this.getAsyncListenersFor(evtType, true);
        if (!this.contains(lst, listener)) {
            lst.add(new SoftReference<AsyncEventListener>(listener));
            this._reverseMap.put(listener, evtType);
        } else {
            Log.info(this.getClass(), (Object)("A listener is already registered for: " + evtType));
        }
    }

    public synchronized void registerSyncListener(String evtType, SyncEventListener listener) throws ListenerAlreadyRegisteredException {
        if (this._syncListenersByEvent.get(evtType) != null) {
            throw new ListenerAlreadyRegisteredException(evtType);
        }
        this._syncListenersByEvent.put(evtType, new SoftReference<SyncEventListener>(listener));
        this._reverseMap.put(listener, evtType);
    }

    public synchronized void unregisterListener(SyncEventListener listener) {
        String evtId = (String)this._reverseMap.remove(listener);
        if (evtId != null) {
            this._syncListenersByEvent.remove(evtId);
        }
    }

    public synchronized void unregisterListener(AsyncEventListener listener) {
        List lst;
        String evtId = (String)this._reverseMap.remove(listener);
        if (evtId != null && (lst = this.getAsyncListenersFor(evtId, false)) != null) {
            for (int i = 0; i < lst.size(); ++i) {
                SoftReference contained = (SoftReference)lst.get(i);
                AsyncEventListener instance = (AsyncEventListener)contained.get();
                if (instance == null) {
                    lst.remove(i);
                    --i;
                    continue;
                }
                if (!contained.get().equals(instance)) continue;
                lst.remove(i);
                break;
            }
        }
    }

    public boolean containsAsyncListener(AsyncEventListener listener) {
        String type = (String)this._reverseMap.get(listener);
        if (type != null) {
            List listeners = (List)this._asyncListenersByEvent.get(type);
            return this.contains(listeners, listener);
        }
        return false;
    }

    public boolean hasSyncListener(String evtType) {
        return this._syncListenersByEvent.get(evtType) != null;
    }

    public boolean containsSyncListener(SyncEventListener listener) {
        return this._reverseMap.get(listener) != null;
    }

    public int getCount() {
        return this._reverseMap.size();
    }

    protected void onAsyncEvent(RemoteEvent evt) {
        DomainName dn = null;
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("Received remote event: " + evt.getType() + "@" + evt.getNode() + "@" + evt.getDomainName()));
            Log.debug(this.getClass(), (Object)("Event from this node: " + evt.getNode().equals(this._node)));
        }
        if (evt.getDomainName() != null) {
            dn = DomainName.parse(evt.getDomainName());
        }
        if (this.matchesAll(dn, evt.getNode())) {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)"Notifying...");
            }
            this.notifyAsyncListeners(evt);
        } else if (this.matchesThis(dn, evt.getNode())) {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)"Notifying...");
            }
            this.notifyAsyncListeners(evt);
        } else if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("Event was not matched: " + evt.getType()));
        }
    }

    protected boolean matchesAll(DomainName dn, String node) {
        return dn == null && node != null && !node.equals(this._node);
    }

    protected boolean matchesThis(DomainName dn, String node) {
        return dn != null && this._domain.contains(dn) && node != null && !node.equals(this._node);
    }

    protected synchronized Object onSyncEvent(RemoteEvent evt) {
        DomainName dn = null;
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("Received remote event: " + evt.getType() + "@" + evt.getDomainName()));
            Log.debug(this.getClass(), (Object)("Event from this node: " + evt.getNode().equals(this._node)));
        }
        if (evt.getDomainName() != null) {
            dn = DomainName.parse(evt.getDomainName());
        }
        if (dn == null && evt.getNode() != null && !evt.getNode().equals(this._node)) {
            SyncEventListener sync = (SyncEventListener)((SoftReference)this._syncListenersByEvent.get(evt.getType())).get();
            if (sync != null) {
                if (Log.isDebug()) {
                    Log.debug(this.getClass(), (Object)("Dispatching sync event to: " + sync));
                }
                return sync.onSyncEvent(evt);
            }
            Log.debug(this.getClass(), (Object)("No listener for event: " + evt.getType()));
            this._syncListenersByEvent.remove(evt.getType());
        } else if (dn != null && this._domain.contains(dn) && evt.getNode() != null && !evt.getNode().equals(this._node)) {
            SyncEventListener sync = (SyncEventListener)((SoftReference)this._syncListenersByEvent.get(evt.getType())).get();
            if (sync != null) {
                if (Log.isDebug()) {
                    Log.debug(this.getClass(), (Object)("Dispatching sync event to: " + sync));
                }
                return sync.onSyncEvent(evt);
            }
            Log.debug(this.getClass(), (Object)("No listener for event: " + evt.getType()));
            this._syncListenersByEvent.remove(evt.getType());
        }
        return null;
    }

    private synchronized void notifyAsyncListeners(RemoteEvent evt) {
        List lst = this.getAsyncListenersFor(evt.getType(), false);
        if (lst != null) {
            if (lst.size() == 0 && Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("No listener for event: " + evt.getType()));
            }
            for (int i = 0; i < lst.size(); ++i) {
                AsyncEventListener listener = (AsyncEventListener)((SoftReference)lst.get(i)).get();
                if (listener == null) {
                    Log.debug(this.getClass(), (Object)("Async listener reference is null for: " + evt.getType()));
                    lst.remove(i);
                    --i;
                    continue;
                }
                Log.debug(this.getClass(), (Object)("Notifying async listener for: " + evt.getType() + " -> " + listener));
                listener.onAsyncEvent(evt);
            }
        } else {
            Log.debug(this.getClass(), (Object)("No async listeners for: " + evt.getType()));
        }
    }

    private List getAsyncListenersFor(String evtId, boolean create) {
        ArrayList lst = (ArrayList)this._asyncListenersByEvent.get(evtId);
        if (lst == null && create) {
            lst = new ArrayList();
            this._asyncListenersByEvent.put(evtId, lst);
        }
        return lst;
    }

    protected boolean contains(List listeners, AsyncEventListener listener) {
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                SoftReference contained = (SoftReference)listeners.get(i);
                AsyncEventListener instance = (AsyncEventListener)contained.get();
                if (instance == null) {
                    listeners.remove(i);
                    --i;
                    continue;
                }
                if (!contained.get().equals(listener)) continue;
                return true;
            }
        }
        return false;
    }

    private static synchronized int inc() {
        return _count++;
    }

    static {
        _rand = new Random();
    }
}

