/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.mcast;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RemoteEvent
implements Serializable {
    static final int BUFSZ = 1048;
    static int _inc = 0;
    static final int MAX_INC = 1000;
    private String _domain;
    private String _type;
    private long _id = RemoteEvent.generateId();
    private String _node;
    private byte[] _data;
    private boolean _wasBytes;
    private boolean _sync;

    public RemoteEvent(String domain, String type, Object data) throws IOException {
        this._domain = domain;
        this._type = type;
        if (data != null && data instanceof byte[]) {
            this._wasBytes = true;
            this._data = (byte[])data;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1048);
            ObjectOutputStream ous = new ObjectOutputStream(bos);
            ous.writeObject(data);
            ous.flush();
            ous.close();
            this._data = bos.toByteArray();
        }
    }

    public RemoteEvent(String type, Object data) throws IOException {
        this(null, type, data);
    }

    public String getDomainName() {
        return this._domain;
    }

    public String getType() {
        return this._type;
    }

    public long getId() {
        return this._id;
    }

    public Object getData() throws IOException {
        if (this._data != null) {
            if (this._wasBytes) {
                return this._data;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(this._data);
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                Object obj;
                Object object = obj = ois.readObject();
                return object;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getClass().getName() + " caught: " + e.getMessage());
            }
            finally {
                ois.close();
            }
        }
        return this._data;
    }

    public boolean hasDomainName() {
        return this._domain != null;
    }

    public boolean isSync() {
        return this._sync;
    }

    public String getNode() {
        return this._node;
    }

    RemoteEvent setNode(String node) {
        this._node = node;
        return this;
    }

    RemoteEvent setSync() {
        this._sync = true;
        return this;
    }

    private static synchronized long generateId() {
        if (_inc++ > 1000) {
            _inc = 0;
        }
        return Long.parseLong("" + System.currentTimeMillis() + _inc);
    }
}

