/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.mcast;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import org.sapia.ubik.mcast.EventConsumer;
import org.sapia.ubik.mcast.InetServerAddress;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.mcast.RespList;
import org.sapia.ubik.mcast.Response;
import org.sapia.ubik.mcast.SocketTimeoutListener;
import org.sapia.ubik.mcast.TimeoutException;
import org.sapia.ubik.mcast.UnicastDispatcher;
import org.sapia.ubik.mcast.Util;
import org.sapia.ubik.mcast.server.UDPServer;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.util.Localhost;

public class UDPUnicastDispatcher
extends UDPServer
implements UnicastDispatcher {
    static final int DEFAULT_BUFSZ = 5000;
    private EventConsumer _consumer;
    private int _bufsize = 5000;
    private int _responseTimeout = 10000;
    private String _domain;
    private String _node;
    private SocketTimeoutListener _listener;
    private ServerAddress _addr;

    public UDPUnicastDispatcher(int soTimeout, EventConsumer consumer) throws SocketException {
        super(consumer.getNode() + "Unicast@" + consumer.getDomainName().toString(), soTimeout);
        this._consumer = consumer;
        this._domain = consumer.getDomainName().toString();
        this._node = consumer.getNode();
    }

    public UDPUnicastDispatcher(int soTimeout, int port, EventConsumer consumer) throws SocketException {
        super(consumer.getNode() + "@" + consumer.getDomainName().toString(), soTimeout, port);
        this._consumer = consumer;
        this._domain = consumer.getDomainName().toString();
        this._node = consumer.getNode();
    }

    @Override
    public void setBufsize(int size) {
        super.setBufsize(size);
        this._bufsize = size;
    }

    @Override
    public void setSoTimeoutListener(SocketTimeoutListener listener) {
        this._listener = listener;
    }

    @Override
    public void start() {
        super.start();
        try {
            InetAddress addr = Localhost.getAnyLocalAddress();
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("Local address: " + addr.getHostAddress()));
            }
            this._addr = new InetServerAddress(addr, this.getPort());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this._sock != null) {
            this._sock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(ServerAddress addr, String type, Object data) throws IOException {
        DatagramSocket sock = new DatagramSocket();
        sock.setSoTimeout(this._responseTimeout);
        try {
            RemoteEvent evt = new RemoteEvent(null, type, data).setNode(this._node);
            InetServerAddress inet = (InetServerAddress)addr;
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("dispatch() : " + addr + ", type: " + type + ", data: " + data));
            }
            this.doSend(inet.getInetAddress(), inet.getPort(), sock, Util.toBytes(evt, this.bufSize()), false, type);
        }
        catch (TimeoutException e) {
        }
        finally {
            try {
                sock.close();
            }
            catch (RuntimeException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response send(ServerAddress addr, String type, Object data) throws IOException {
        DatagramSocket sock = new DatagramSocket();
        sock.setSoTimeout(this._responseTimeout);
        RemoteEvent evt = new RemoteEvent(null, type, data).setNode(this._node).setSync();
        InetServerAddress inet = (InetServerAddress)addr;
        try {
            Response response = (Response)this.doSend(inet.getInetAddress(), inet.getPort(), sock, Util.toBytes(evt, this.bufSize()), true, type);
            return response;
        }
        catch (TimeoutException e) {
            Response response = new Response(evt.getId(), null).setStatusSuspect();
            return response;
        }
        finally {
            try {
                sock.close();
            }
            catch (RuntimeException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RespList send(List addresses, String type, Object data) throws IOException {
        DatagramSocket sock = new DatagramSocket();
        sock.setSoTimeout(this._responseTimeout);
        try {
            RemoteEvent evt = new RemoteEvent(null, type, data).setNode(this._node).setSync();
            byte[] bytes = Util.toBytes(evt, this.bufSize());
            RespList resps = new RespList(addresses.size());
            for (int i = 0; i < addresses.size(); ++i) {
                Response resp;
                InetServerAddress current = (InetServerAddress)addresses.get(i);
                try {
                    resp = (Response)this.doSend(current.getInetAddress(), current.getPort(), sock, bytes, true, type);
                }
                catch (TimeoutException e) {
                    resp = new Response(evt.getId(), null).setStatusSuspect();
                }
                if (resp.isNone()) continue;
                resps.addResponse(resp);
            }
            RespList respList = resps;
            return respList;
        }
        finally {
            try {
                sock.close();
            }
            catch (RuntimeException e) {}
        }
    }

    @Override
    public ServerAddress getAddress() throws IllegalStateException {
        if (this._addr == null) {
            throw new IllegalStateException("The address of this instance is not yet available");
        }
        return this._addr;
    }

    @Override
    protected void handleSoTimeout() {
        if (this._listener != null) {
            this._listener.handleSoTimeout();
        }
    }

    @Override
    protected void handlePacketSizeToShort(DatagramPacket pack) {
        String msg = "Buffer size to short; set to: " + this.bufSize() + ". This size is not enough to receive some incoming packets";
        Log.error(this.getClass(), (Object)msg);
    }

    @Override
    protected int bufSize() {
        return super.bufSize();
    }

    @Override
    protected void handle(DatagramPacket pack, DatagramSocket sock) {
        try {
            Object o = Util.fromDatagram(pack);
            if (o instanceof RemoteEvent) {
                RemoteEvent evt = (RemoteEvent)o;
                if (evt.isSync()) {
                    InetAddress addr = pack.getAddress();
                    int port = pack.getPort();
                    if (this._consumer.hasSyncListener(evt.getType())) {
                        Object response = this._consumer.onSyncEvent(evt);
                        try {
                            this.doSend(addr, port, sock, Util.toBytes(new Response(evt.getId(), response), this.bufSize()), false, evt.getType());
                        }
                        catch (TimeoutException e) {}
                    } else {
                        try {
                            this.doSend(addr, port, sock, Util.toBytes(new Response(evt.getId(), null).setNone(), this.bufSize()), false, evt.getType());
                        }
                        catch (TimeoutException e) {}
                    }
                } else {
                    this._consumer.onAsyncEvent(evt);
                }
            } else {
                Log.error(this.getClass(), (Object)("Object not a remote event: " + o.getClass().getName() + "; " + o));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private Object doSend(InetAddress addr, int port, DatagramSocket sock, byte[] bytes, boolean synchro, String type) throws IOException, TimeoutException {
        if (bytes.length > this._bufsize) {
            throw new IOException("Size of data larger than buffer size; increase this instance's buffer size through the setBufsize() method");
        }
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("doSend() : " + addr + ", event type: " + type));
        }
        DatagramPacket pack = new DatagramPacket(bytes, 0, bytes.length, addr, port);
        sock.send(pack);
        if (synchro) {
            bytes = new byte[this.bufSize()];
            pack = new DatagramPacket(bytes, bytes.length);
            try {
                sock.receive(pack);
            }
            catch (InterruptedIOException e) {
                throw new TimeoutException();
            }
            try {
                return Util.fromDatagram(pack);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        return null;
    }
}

