/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.mcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sapia.ubik.net.ServerAddress;

public class View {
    private Map _addresses = new HashMap();
    private Map _nodeToAddr = new HashMap();
    private long _timeout;

    public View(long timeout) {
        this._timeout = timeout;
    }

    public synchronized List getHosts() {
        return new AddressList((Collection)this._addresses.keySet());
    }

    public ServerAddress getAddressFor(String node) {
        NodeInfo info = (NodeInfo)this._nodeToAddr.get(node);
        return info.addr;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    void addHost(ServerAddress addr, String node) {
        NodeInfo info = new NodeInfo(addr, node);
        this._nodeToAddr.put(node, info);
        this._addresses.put(info, new Long(System.currentTimeMillis()));
    }

    void heartbeat(ServerAddress addr, String node) {
        this._addresses.put(new NodeInfo(addr, node), new Long(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDeadHosts() {
        Map map = this._addresses;
        synchronized (map) {
            Map.Entry[] hosts = this._addresses.entrySet().toArray(new Map.Entry[this._addresses.size()]);
            for (int i = 0; i < hosts.length; ++i) {
                if (System.currentTimeMillis() - (Long)hosts[i].getValue() <= this._timeout) continue;
                NodeInfo info = (NodeInfo)hosts[i].getKey();
                this._addresses.remove(info);
                this._nodeToAddr.remove(info.node);
            }
        }
    }

    public static class AddressList
    extends ArrayList {
        AddressList(Collection infos) {
            super(infos);
        }

        @Override
        public Object get(int idx) {
            return ((NodeInfo)super.get((int)idx)).addr;
        }
    }

    static class NodeInfo {
        final ServerAddress addr;
        final String node;

        NodeInfo(ServerAddress addr, String node) {
            this.addr = addr;
            this.node = node;
        }

        public boolean equals(Object obj) {
            NodeInfo inf = (NodeInfo)obj;
            return ((Object)inf.addr).equals(this.addr) && inf.node.equals(this.node);
        }

        public int hashCode() {
            return this.addr.hashCode();
        }
    }
}

