/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.mcast.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.sapia.ubik.mcast.ByteArrayPool;
import org.sapia.ubik.rmi.server.Log;

public abstract class MulticastServer
extends Thread {
    static final int DEFAULT_BUFSZ = 20000;
    static final int TTL = 7;
    protected MulticastSocket _sock;
    private InetAddress _group;
    private String _groupStr;
    private int _port;
    private ByteArrayPool _bytes = new ByteArrayPool(20000);

    public MulticastServer(String name, int soTimeout, String mcastAddress, int mcastPort, int ttl) throws IOException {
        super(name);
        super.setDaemon(true);
        this._group = InetAddress.getByName(mcastAddress);
        this._groupStr = mcastAddress;
        this._sock = new MulticastSocket(mcastPort);
        this._sock.setSoTimeout(soTimeout);
        this._sock.setTimeToLive(ttl);
        this._sock.joinGroup(this._group);
        this._port = mcastPort;
    }

    public MulticastServer(String name, int soTimeout, String mcastAddress, int mcastPort) throws IOException {
        this(name, soTimeout, mcastAddress, mcastPort, 7);
    }

    public void setBufsize(int size) {
        this._bytes.setBufSize(size);
    }

    public String getMulticastAddress() {
        return this._groupStr;
    }

    public int getMulticastPort() {
        return this._port;
    }

    public void send(byte[] toSend) throws IOException {
        if (this._sock == null) {
            throw new IllegalStateException("Server not started");
        }
        DatagramPacket pack = new DatagramPacket(toSend, toSend.length, this._group, this._port);
        this._sock.send(pack);
    }

    public void close() {
        try {
            this._sock.leaveGroup(this._group);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._sock.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DatagramPacket pack = null;
        while (true) {
            byte[] bytes = null;
            try {
                bytes = (byte[])this._bytes.acquire();
            }
            catch (Exception e) {
                Log.error(this.getClass(), (Object)"Could not acquire byte buffer");
                e.printStackTrace();
                break;
            }
            try {
                pack = new DatagramPacket(bytes, bytes.length);
                this._sock.receive(pack);
                this.handle(pack, this._sock);
                continue;
            }
            catch (InterruptedIOException e) {
                this.handleSoTimeout();
                continue;
            }
            catch (EOFException e) {
                this.handlePacketSizeToShort(pack);
                continue;
            }
            catch (SocketException e) {
                if (!this._sock.isClosed()) continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                this._bytes.release(bytes);
                continue;
            }
            break;
        }
    }

    protected int bufSize() {
        return this._bytes.getBufSize();
    }

    protected abstract void handleSoTimeout();

    protected abstract void handlePacketSizeToShort(DatagramPacket var1);

    protected abstract void handle(DatagramPacket var1, MulticastSocket var2);
}

