/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.mcast.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public abstract class UDPServer
extends Thread {
    static final int DEFAULT_BUFSZ = 1000;
    protected DatagramSocket _sock;
    private int _bufsize = 1000;

    public UDPServer(String name, int soTimeout) throws SocketException {
        super(name);
        super.setDaemon(true);
        this._sock = new DatagramSocket();
        this._sock.setSoTimeout(soTimeout);
    }

    public UDPServer(String name, int soTimeout, int port) throws SocketException {
        super(name);
        this._sock = new DatagramSocket(port);
        this._sock.setSoTimeout(soTimeout);
    }

    public void setBufsize(int size) {
        this._bufsize = size;
    }

    public int getPort() {
        return this._sock.getLocalPort();
    }

    @Override
    public void run() {
        DatagramPacket pack = null;
        while (true) {
            try {
                while (true) {
                    pack = new DatagramPacket(new byte[this._bufsize], this._bufsize);
                    this._sock.receive(pack);
                    this.handle(pack, this._sock);
                }
            }
            catch (InterruptedIOException e) {
                this.handleSoTimeout();
                continue;
            }
            catch (SocketException e) {
                if (!this._sock.isClosed()) continue;
            }
            catch (EOFException e) {
                this.handlePacketSizeToShort(pack);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected int bufSize() {
        return this._bufsize;
    }

    protected abstract void handleSoTimeout();

    protected abstract void handlePacketSizeToShort(DatagramPacket var1);

    protected abstract void handle(DatagramPacket var1, DatagramSocket var2);
}

