/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.io.IOException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Vector;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.ConnectionFactory;
import org.sapia.ubik.net.SocketConnectionFactory;

public class ConnectionPool {
    public static final long DEFAULT_ACQUIRE_TIME_OUT = 2000L;
    private Vector _conns = new Vector(50);
    protected ConnectionFactory _fac;
    protected String _host;
    protected int _port;
    protected int _maxSize;
    protected int _currentCount;
    protected long _lastUsageTime = System.currentTimeMillis();
    protected RMIClientSocketFactory _socketFactory;

    public ConnectionPool(String host, int port, ConnectionFactory fac, RMIClientSocketFactory socketFactory) {
        this._fac = fac;
        this._host = host;
        this._port = port;
        this._socketFactory = socketFactory;
    }

    public ConnectionPool(String host, int port, ConnectionFactory fac, RMIClientSocketFactory socketFactory, int maxSize) {
        this(host, port, fac, socketFactory);
        this._maxSize = maxSize;
    }

    public ConnectionPool(String host, int port, RMIClientSocketFactory socketFactory) {
        this(host, port, new SocketConnectionFactory(), socketFactory);
    }

    public ConnectionPool(String host, int port, int maxSize, RMIClientSocketFactory socketFactory) {
        this(host, port, new SocketConnectionFactory(), socketFactory, maxSize);
    }

    public synchronized Connection acquire() throws IOException {
        return this.acquire(2000L);
    }

    public synchronized Connection acquire(long timeout) throws IOException {
        Connection conn;
        if (this._conns.size() == 0) {
            if (this._maxSize <= 0) {
                conn = this.newConnection();
            } else if (this._conns.size() == 0) {
                try {
                    if (timeout > 0L) {
                        this.wait(timeout);
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException("thread interrupted");
                }
                if (this._currentCount >= this._maxSize) {
                    throw new IOException("maximum connection pool size reached");
                }
                conn = this.newConnection();
            } else {
                conn = (Connection)this._conns.remove(0);
            }
        } else {
            conn = (Connection)this._conns.remove(0);
        }
        return conn;
    }

    public synchronized void release(Connection conn) {
        this._lastUsageTime = System.currentTimeMillis();
        this._conns.add(conn);
        this.notify();
    }

    public synchronized int getCount() {
        return this._currentCount;
    }

    public long getLastUsageTime() {
        return this._lastUsageTime;
    }

    public synchronized void shrinkTo(int size) {
        while (this._conns.size() > size && this._conns.size() > 0) {
            --this._currentCount;
            if (this._currentCount < 0) {
                this._currentCount = 0;
            }
            Connection conn = (Connection)this._conns.remove(0);
            conn.close();
        }
    }

    protected Connection newConnection() throws IOException {
        ++this._currentCount;
        return this._fac.newConnection(this._host, this._port);
    }
}

