/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.io.IOException;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.DefaultUbikServerSocketFactory;
import org.sapia.ubik.net.PooledThread;
import org.sapia.ubik.net.Request;
import org.sapia.ubik.net.SocketServer;
import org.sapia.ubik.net.ThreadPool;

public class MyServer
extends SocketServer {
    public MyServer() throws IOException {
        super(6666, (ThreadPool)new MyThreadPool(), new DefaultUbikServerSocketFactory());
    }

    public static void main(String[] args) {
        try {
            MyServer svr = new MyServer();
            Thread t = new Thread(svr);
            t.start();
            svr.waitStarted();
            System.out.println("Server started");
            while (true) {
                Thread.sleep(100000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static class MyPooledThread
    extends PooledThread {
        MyPooledThread() {
        }

        @Override
        protected void doExec(Object task) {
            Connection conn = ((Request)task).getConnection();
            try {
                while (true) {
                    System.out.println(conn.receive());
                    conn.send("Hello");
                }
            }
            catch (Throwable t) {
                conn.close();
                t.printStackTrace();
                return;
            }
        }

        @Override
        protected void handleExecutionException(Exception e) {
            e.printStackTrace();
        }
    }

    static class MyThreadPool
    extends ThreadPool {
        MyThreadPool() {
            super("myThread", true, 10);
        }

        @Override
        protected PooledThread newThread() throws Exception {
            return new MyPooledThread();
        }
    }
}

