/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sapia.ubik.net.NoObjectAvailableException;

public abstract class Pool {
    public static final long NO_TIME_OUT = -1L;
    public static final int NO_MAX = 0;
    protected List _objects = Collections.synchronizedList(new ArrayList(50));
    protected int _maxSize = 0;
    protected int _currentCount;
    protected long _lastUsageTime = System.currentTimeMillis();

    public Pool() {
    }

    public Pool(int maxSize) {
        this._maxSize = maxSize;
    }

    public synchronized Object acquire() throws InterruptedException, Exception {
        return this.acquire(-1L);
    }

    public synchronized Object acquire(long timeout) throws InterruptedException, NoObjectAvailableException, Exception {
        Object obj;
        this._lastUsageTime = System.currentTimeMillis();
        if (this._objects.size() == 0) {
            if (this._maxSize <= 0) {
                obj = this.newObject();
            } else {
                long start = System.currentTimeMillis();
                while (this._objects.size() == 0) {
                    if (timeout > 0L) {
                        this.wait(timeout);
                        if (System.currentTimeMillis() - start <= timeout) continue;
                        break;
                    }
                    if (this._currentCount <= this._maxSize) break;
                    this.wait();
                }
                if (this._objects.size() == 0) {
                    if (this._currentCount >= this._maxSize) {
                        throw new NoObjectAvailableException();
                    }
                    obj = this.newObject();
                } else {
                    obj = this._objects.remove(0);
                }
            }
        } else {
            obj = this._objects.remove(0);
        }
        return this.onAcquire(obj);
    }

    protected Object onAcquire(Object o) throws Exception {
        return o;
    }

    protected void onRelease(Object o) {
    }

    public synchronized void release(Object obj) {
        this._objects.add(obj);
        this.onRelease(obj);
        this.notify();
    }

    public long getLastUsageTime() {
        return this._lastUsageTime;
    }

    public int getCreatedCount() {
        return this._currentCount;
    }

    public int size() {
        return this._objects.size();
    }

    public synchronized void shrinkTo(int size) {
        while (this._objects.size() > size && this._objects.size() > 0) {
            --this._currentCount;
            if (this._currentCount < 0) {
                this._currentCount = 0;
            }
            this.cleanup(this._objects.remove(0));
        }
    }

    public synchronized void fill(int toSize) throws Exception {
        for (int i = 0; i < toSize && (this._maxSize <= 0 || this._objects.size() < this._maxSize); ++i) {
            this._objects.add(this.newObject());
        }
    }

    public synchronized Object acquireCreate() throws Exception {
        if (this._objects.size() == 0) {
            if (this.getCreatedCount() >= this._maxSize && this._maxSize > 0) {
                return null;
            }
            return this.acquire();
        }
        return this.acquire();
    }

    protected abstract Object doNewObject() throws Exception;

    protected void cleanup(Object pooled) {
    }

    private Object newObject() throws Exception {
        Object toReturn = this.doNewObject();
        ++this._currentCount;
        return toReturn;
    }
}

