/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.sapia.ubik.net.QueryString;

public class QueryStringParser
implements NameParser {
    static final char QMARK = '?';
    static final String AMP = "&";
    static final char EQ = '=';
    static final String SLASH = "/";

    public QueryString parseQueryString(String string) {
        QueryString qs = new QueryString();
        if (string == null || string.length() == 0) {
            return qs;
        }
        this.parseName(qs, string);
        return qs;
    }

    public Enumeration parseNameTokens(String queryString) {
        Vector<String> tokens = new Vector<String>();
        QueryString qs = new QueryString();
        this.parseName(qs, queryString);
        StringTokenizer st = new StringTokenizer(qs.getPath(), SLASH);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        if (qs.getParameters().size() > 0) {
            StringBuffer buf = new StringBuffer((String)tokens.lastElement());
            buf.append('?');
            Iterator itr = qs.getParameters().entrySet().iterator();
            int count = 0;
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (count > 0) {
                    buf.append(AMP);
                }
                buf.append(entry.getKey().toString()).append('=').append(entry.getValue());
                ++count;
            }
            tokens.set(tokens.size() - 1, buf.toString());
        }
        return tokens.elements();
    }

    @Override
    public Name parse(String queryString) throws NamingException {
        return new CompositeNameEx(this.parseNameTokens(queryString));
    }

    public String nameToString(Name n) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < n.size(); ++i) {
            buf.append(n.get(i));
            if (i >= n.size() - 1) continue;
            buf.append(SLASH);
        }
        return buf.toString();
    }

    private void parseName(QueryString qs, String name) {
        int idx = name.indexOf(63);
        if (idx < 0) {
            qs.setPath(name);
            return;
        }
        qs.setPath(name.substring(0, idx));
        if (idx == name.length() - 1) {
            return;
        }
        this.parseProperties(qs, name.substring(idx + 1));
    }

    private void parseProperties(QueryString tn, String props) {
        StringTokenizer st = new StringTokenizer(props, AMP);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.parseProperty(tn, token);
        }
    }

    private void parseProperty(QueryString qs, String prop) {
        String name = null;
        String value = null;
        int idx = prop.indexOf(61);
        if (idx < 0) {
            if (prop.length() > 0) {
                name = prop;
            }
        } else {
            name = prop.substring(0, idx);
            if (idx != prop.length() - 1) {
                value = prop.substring(idx + 1);
            }
        }
        if (name != null && value != null) {
            qs.addParameter(name, value);
        }
    }

    static final class CompositeNameEx
    extends CompositeName {
        protected CompositeNameEx(Enumeration en) {
            super(en);
        }
    }
}

