/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import org.sapia.ubik.net.MaxThreadReachedException;
import org.sapia.ubik.net.ThreadFactory;

public class Semaphore {
    public static final int NO_MAX = 0;
    private int _maxThread = 0;
    private int _count = 0;
    private ThreadFactory _fac = new DefaultThreadFactory();

    public Semaphore(int maxThread) {
        this._maxThread = maxThread;
    }

    public Semaphore(int maxThread, ThreadFactory fac) {
        this(maxThread);
        this._fac = fac;
    }

    synchronized void release() {
        this._count = --this._count < 0 ? 0 : this._count;
    }

    public synchronized int getThreadCount() {
        return this._count;
    }

    public synchronized Thread acquireFor(Runnable r) throws MaxThreadReachedException {
        if (this._maxThread > 0 && this._count >= this._maxThread) {
            throw new MaxThreadReachedException("" + this._count);
        }
        ++this._count;
        return this._fac.newThreadFor(new SemaphoreRunnable(this, r));
    }

    static final class DefaultThreadFactory
    implements ThreadFactory {
        DefaultThreadFactory() {
        }

        @Override
        public Thread newThreadFor(Runnable r) {
            return new Thread(r);
        }
    }

    public static final class SemaphoreRunnable
    implements Runnable {
        private Semaphore _sema;
        private Runnable _toRun;

        private SemaphoreRunnable(Semaphore s, Runnable toRun) {
            this._sema = s;
            this._toRun = toRun;
        }

        @Override
        public final void run() {
            this._toRun.run();
            this._sema.release();
        }
    }
}

