/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.RemoteException;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.TCPAddress;

public class SocketConnection
implements Connection {
    static final long DEFAULT_RESET_INTERVAL = 2000L;
    protected Socket _sock;
    protected TCPAddress _address;
    protected ClassLoader _loader;
    protected ObjectInputStream _is;
    protected ObjectOutputStream _os;
    protected long _lastReset;
    protected long _resetInterval = 2000L;
    private int callCount = 0;

    public SocketConnection(Socket sock, ClassLoader loader) {
        this(sock);
        this._loader = loader;
    }

    public SocketConnection(Socket sock) {
        this._sock = sock;
        this._address = new TCPAddress(sock.getInetAddress().getHostAddress(), sock.getPort());
    }

    public void setResetInterval(long interval) {
        this._resetInterval = interval;
    }

    @Override
    public void send(Object o) throws IOException, RemoteException {
        this.writeHeader(this._sock.getOutputStream(), this._loader);
        this.doSend(o, this._os);
    }

    @Override
    public Object receive() throws IOException, ClassNotFoundException, RemoteException {
        try {
            this.readHeader(this._sock.getInputStream(), this._loader);
            return this._is.readObject();
        }
        catch (EOFException e) {
            throw new RemoteException("Communication with server interrupted; server probably disappeared", e);
        }
        catch (SocketException e) {
            throw new RemoteException("Connection could not be opened; server is probably down", e);
        }
    }

    @Override
    public void close() {
        try {
            if (this._os != null) {
                this._os.reset();
                this._os.close();
                this._os = null;
            }
            if (this._is != null) {
                this._is.close();
                this._is = null;
            }
            this._sock.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._address;
    }

    public InputStream getInputStream() throws IOException {
        return this._sock.getInputStream();
    }

    public OutputStream getOuputStream() throws IOException {
        return this._sock.getOutputStream();
    }

    protected ObjectOutputStream newOutputStream(OutputStream os, ClassLoader loader) throws IOException {
        return new ObjectOutputStream(os);
    }

    protected ObjectInputStream newInputStream(InputStream is, ClassLoader loader) throws IOException {
        return new ObjectInputStream(is);
    }

    protected void doSend(Object toSend, ObjectOutputStream mos) throws IOException {
        try {
            this._os.writeObject(toSend);
            this._os.flush();
        }
        catch (SocketException e) {
            throw new RemoteException("Communication with server interrupted; server probably disappeared", e);
        }
        catch (EOFException e) {
            throw new RemoteException("Communication with server interrupted; server probably disappeared", e);
        }
    }

    protected void writeHeader(OutputStream os, ClassLoader loader) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        if (this._os == null || System.currentTimeMillis() - this._lastReset >= this._resetInterval) {
            this._lastReset = System.currentTimeMillis();
            dos.writeBoolean(true);
            dos.flush();
            this._os = null;
            this._os = this.newOutputStream(os, loader);
            this.callCount = 0;
        } else {
            dos.writeBoolean(false);
            dos.flush();
        }
        ++this.callCount;
    }

    protected void readHeader(InputStream is, ClassLoader loader) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        boolean reset = dis.readBoolean();
        if (this._is == null || reset) {
            this._is = null;
            this._is = this.newInputStream(is, loader);
        }
    }
}

