/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.io.IOException;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.ConnectionFactory;
import org.sapia.ubik.net.SocketConnection;

public class SocketConnectionFactory
implements ConnectionFactory {
    protected ClassLoader _loader;
    protected RMIClientSocketFactory _clientSocketFactory;

    public SocketConnectionFactory() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public SocketConnectionFactory(RMIClientSocketFactory client) {
        this(Thread.currentThread().getContextClassLoader());
        this._clientSocketFactory = client;
    }

    public SocketConnectionFactory(RMIClientSocketFactory client, ClassLoader loader) {
        this(loader);
        this._clientSocketFactory = client;
    }

    public SocketConnectionFactory(ClassLoader loader) {
        this._loader = loader;
    }

    @Override
    public Connection newConnection(String host, int port) throws IOException {
        if (this._clientSocketFactory == null) {
            return new SocketConnection(new Socket(host, port), this._loader);
        }
        return new SocketConnection(this._clientSocketFactory.createSocket(host, port), this._loader);
    }

    public Connection newConnection(Socket sock) throws IOException {
        return new SocketConnection(sock, this._loader);
    }
}

